<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.wpcostarica.com
 * @since             1.0.0
 * @package           Wpcr_Sportsbooks_Reviews
 *
 * @wordpress-plugin
 * Plugin Name:       Sportsbooks Reviews
 * Plugin URI:        https://www.wpcostarica.com
 * Description:       Allows to implement a template for Reviews by means of blocks.
 * Version:           1.0.32
 * Author:            WPCR
 * Author URI:        https://www.wpcostarica.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wpcr-sportsbooks-reviews
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'WPCR_SPORTSBOOKS_REVIEWS_VERSION', '1.0.1' );

define( 'WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY',  plugin_dir_path( __FILE__ ));
define( 'WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY_URL',  plugin_dir_url( __FILE__ ));

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wpcr-sportsbooks-reviews-activator.php
 */
function activate_wpcr_sportsbooks_reviews() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wpcr-sportsbooks-reviews-activator.php';
	Wpcr_Sportsbooks_Reviews_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wpcr-sportsbooks-reviews-deactivator.php
 */
function deactivate_wpcr_sportsbooks_reviews() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wpcr-sportsbooks-reviews-deactivator.php';
	Wpcr_Sportsbooks_Reviews_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wpcr_sportsbooks_reviews' );
register_deactivation_hook( __FILE__, 'deactivate_wpcr_sportsbooks_reviews' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wpcr-sportsbooks-reviews.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wpcr_sportsbooks_reviews() {

	$plugin = new Wpcr_Sportsbooks_Reviews();
	$plugin->run();
}

run_wpcr_sportsbooks_reviews();

add_filter('template_include', 'template_chooser');
function template_chooser($template) {
    global $wp_query;
    $plugindir = dirname(__FILE__);

    $post_type = $wp_query->queried_object->post_type;

    if( $post_type == 'reviews'){
        return $plugindir . '/templates/wpcr-review-new.php';
    }

    return $template;   
}

require plugin_dir_path( __FILE__ ) . 'includes/class-wpcr-sportsbooks-blocks.php';

/**
 * Custom fields necessary to define the spacing of the blocks are loaded
 */
function wpcr_sportsbooks_blocks() {

	$blocks = new Wpcr_Sportsbooks_Blocks();
    $blocks->Wpcr_Sportsbooks_Blocks_Spaces_Fields();
    $blocks->Wpcr_Sportsbooks_Template_Review_Breadcrumbs();
}

wpcr_sportsbooks_blocks();

function get_spaces_classes($fields) {

	$blocks = new Wpcr_Sportsbooks_Blocks();
    return $blocks->Wpcr_Sportsbooks_Blocks_Spaces_classes($fields);
}

function get_rating_stars($rating) {

	$utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
    $utils->wpcr_sportsbooks_reviews_stars($rating);
}

add_action('wp_enqueue_scripts', 'wpcr_review_new_scripts');

function wpcr_review_new_scripts() {
    $template_dir = get_template_directory();
    $template_uri = get_template_directory_uri();
    $custom_css_base = basename(plugin_dir_path(__FILE__)).'-templates/wpcr-review-new.css';

    if (file_exists($template_dir.'/'.$custom_css_base)) {
        wp_enqueue_style('wpcr-review-new-style', $template_uri.'/'.$custom_css_base, [], true);
    }
}
