<?php
// Debug Mode Options Page
function shn_base_debug_options_page()
{
    add_submenu_page(
        'shn-base-sw-options',
        'SHN-Base Debug Options',
        'Debug Options',
        'manage_options',
        'shn-base-debug-options',
        'shn_base_debug_options_page_content'
    );
}
add_action('admin_menu', 'shn_base_debug_options_page');

function shn_base_debug_options_page_content()
{
    if (!current_user_can('manage_options')) {
        return;
    }

    settings_errors('shn_base_debug_messages');
?>
    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields('shn_base_debug_options');
            do_settings_sections('shn-base-debug-options');
            submit_button('Save Settings');
            ?>
        </form>
    </div>
<?php
}

function shn_base_debug_register_settings()
{
    register_setting('shn_base_debug_options', 'shn_base_debug_options', 'shn_base_debug_validate_options');

    add_settings_section('debug_settings_section', 'Debug Settings', 'shn_base_debug_section_callback', 'shn-base-debug-options');

    add_settings_field('enable_debug', 'Enable Debug Mode', 'shn_base_debug_enable_callback', 'shn-base-debug-options', 'debug_settings_section');
}
add_action('admin_init', 'shn_base_debug_register_settings');

function shn_base_debug_section_callback($args)
{
    echo '<p>Enable debug mode to display performance metrics on each page.</p>';
}

function shn_base_debug_enable_callback($args)
{
    $options = get_option('shn_base_debug_options');
    $enable_debug = isset($options['enable_debug']) ? $options['enable_debug'] : 0;
    echo '<input type="checkbox" name="shn_base_debug_options[enable_debug]" value="1" ' . checked(1, $enable_debug, false) . ' />';
    echo '<p class="description">Check to enable debug mode.</p>';
}

function shn_base_debug_validate_options($input)
{
    $validated = array();
    $validated['enable_debug'] = isset($input['enable_debug']) ? 1 : 0;
    return $validated;
}

// Add debug info to footer
function shn_base_debug_info()
{
    $options = get_option('shn_base_debug_options');
    $enable_debug = isset($options['enable_debug']) ? $options['enable_debug'] : 0;

    if ($enable_debug) {
        $start_time = defined('SHN_BASE_START_TIME') ? SHN_BASE_START_TIME : $_SERVER['REQUEST_TIME_FLOAT'];
        $end_time = microtime(true);
        $load_time = round(($end_time - $start_time), 4);
        $memory_usage = round(memory_get_peak_usage() / 1024 / 1024, 2);

        echo '<div class="debug-info" style="position: fixed; bottom: 0; left: 0; background: rgba(0,0,0,0.8); color: #fff; padding: 10px; font-size: 12px; z-index: 9999;">';
        echo 'Page load time: ' . $load_time . ' seconds<br>';
        echo 'Memory usage: ' . $memory_usage . ' MB';
        echo '</div>';
    }
}
add_action('wp_footer', 'shn_base_debug_info');
