<?php

/**
 * The sidebar containing the main widget area
 *
 * @package SHN-Base
 */
?>

<aside id="secondary" class="widget-area sidebar" role="complementary" aria-label="<?php esc_attr_e('Sidebar', 'shn-base'); ?>">
    <div class="sidebar-inner">
        <?php if (is_active_sidebar('sidebar-1')) : ?>
            <?php dynamic_sidebar('sidebar-1'); ?>
        <?php else : ?>
            <!-- Default sidebar content when no widgets are active -->
            <section class="widget widget_search">
                <h3 class="widget-title"><?php _e('Search', 'shn-base'); ?></h3>
                <?php get_search_form(); ?>
            </section>

            <section class="widget widget_recent_entries">
                <h3 class="widget-title"><?php _e('Recent Posts', 'shn-base'); ?></h3>
                <ul>
                    <?php
                    $recent_posts = wp_get_recent_posts(array(
                        'numberposts' => 5,
                        'post_status' => 'publish'
                    ));
                    foreach ($recent_posts as $post) :
                    ?>
                        <li>
                            <a href="<?php echo esc_url(get_permalink($post['ID'])); ?>">
                                <?php echo esc_html($post['post_title']); ?>
                            </a>
                            <span class="post-date"><?php echo esc_html(get_the_date('', $post['ID'])); ?></span>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </section>

            <section class="widget widget_categories">
                <h3 class="widget-title"><?php _e('Categories', 'shn-base'); ?></h3>
                <ul>
                    <?php wp_list_categories(array(
                        'orderby' => 'name',
                        'title_li' => '',
                        'show_count' => true,
                    )); ?>
                </ul>
            </section>

            <section class="widget widget_archive">
                <h3 class="widget-title"><?php _e('Archives', 'shn-base'); ?></h3>
                <ul>
                    <?php wp_get_archives(array(
                        'type' => 'monthly',
                        'show_post_count' => true,
                    )); ?>
                </ul>
            </section>

            <?php if (current_user_can('edit_theme_options')) : ?>
                <section class="widget widget_text">
                    <h3 class="widget-title"><?php _e('Add Widgets', 'shn-base'); ?></h3>
                    <div class="textwidget">
                        <p>
                            <?php
                            printf(
                                wp_kses(
                                    __('This sidebar is empty. <a href="%s">Add some widgets</a> to customize it.', 'shn-base'),
                                    array(
                                        'a' => array(
                                            'href' => array(),
                                        ),
                                    )
                                ),
                                esc_url(admin_url('widgets.php'))
                            );
                            ?>
                        </p>
                    </div>
                </section>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</aside><!-- #secondary -->