<?php
// Vite asset loading
function shn_base_vite_assets()
{
    $is_development = defined('WP_DEBUG') && WP_DEBUG;

    if ($is_development && file_exists(get_template_directory() . '/vite.config.js')) {
        // Development mode - load from Vite dev server
        wp_enqueue_script('vite-client', 'http://localhost:3000/@vite/client', array(), null, false);
        wp_enqueue_script('shn-base-main', 'http://localhost:3000/src/js/main.js', array(), null, true);
    } else {
        // Production mode - load built assets
        $manifest_path = get_template_directory() . '/dist/manifest.json';

        if (file_exists($manifest_path)) {
            $manifest = json_decode(file_get_contents($manifest_path), true);

            // Enqueue main JS
            if (isset($manifest['src/js/main.js'])) {
                wp_enqueue_script(
                    'shn-base-main',
                    get_template_directory_uri() . '/dist/' . $manifest['src/js/main.js']['file'],
                    array(),
                    '1.0',
                    true
                );
            }

            // Enqueue main CSS
            if (isset($manifest['src/scss/style.scss'])) {
                wp_enqueue_style(
                    'shn-base-style',
                    get_template_directory_uri() . '/dist/' . $manifest['src/scss/style.scss']['file'],
                    array(),
                    '1.0'
                );
            }
        } else {
            // Fallback to regular CSS/JS if no manifest exists
            wp_enqueue_style('shn-base-style', get_stylesheet_uri(), array(), '1.0');
            wp_enqueue_script('shn-base-main', get_template_directory_uri() . '/js/main.js', array(), '1.0', true);
        }
    }

    // Pass config to JavaScript
    wp_localize_script('shn-base-main', 'shnBaseConfig', array(
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('shn_base_nonce'),
        'enableSW' => get_option('shn_base_sw_options')['enable_sw'] ?? true,
        'enableDebugMode' => get_option('shn_base_debug_options')['enable_debug'] ?? false,
    ));
}
add_action('wp_enqueue_scripts', 'shn_base_vite_assets');
