<?php
// Remove unnecessary WordPress features for speed
function shn_base_cleanup()
{
    // Remove emoji scripts
    remove_action('wp_head', 'print_emoji_detection_script', 7);
    remove_action('wp_print_styles', 'print_emoji_styles');

    // Remove unnecessary meta tags
    remove_action('wp_head', 'wp_generator');
    remove_action('wp_head', 'wlwmanifest_link');
    remove_action('wp_head', 'rsd_link');

    // Remove query strings from static resources
    add_filter('script_loader_src', 'shn_base_remove_query_strings', 15, 1);
    add_filter('style_loader_src', 'shn_base_remove_query_strings', 15, 1);
}
add_action('init', 'shn_base_cleanup');

function shn_base_remove_query_strings($src)
{
    $parts = explode('?ver', $src);
    return $parts[0];
}
