<?php
// Customizer additions
function shn_base_customize_register($wp_customize)
{
    // Add a panel for theme options
    $wp_customize->add_panel('shn_base_options', array(
        'title' => __('SHN-Base Theme Options', 'shn-base'),
        'description' => __('Customize the SHN-Base theme.', 'shn-base'),
        'priority' => 160,
    ));

    // Add a section for colors
    $wp_customize->add_section('shn_base_colors', array(
        'title' => __('Colors', 'shn-base'),
        'panel' => 'shn_base_options',
    ));

    // Add a section for typography
    $wp_customize->add_section('shn_base_typography', array(
        'title' => __('Typography', 'shn-base'),
        'panel' => 'shn_base_options',
    ));

    // Add a section for headings
    $wp_customize->add_section('shn_base_headings', array(
        'title' => __('Headings', 'shn-base'),
        'panel' => 'shn_base_options',
    ));

    // Add a section for buttons
    $wp_customize->add_section('shn_base_buttons', array(
        'title' => __('Buttons', 'shn-base'),
        'panel' => 'shn_base_options',
    ));

    // Add a section for links
    $wp_customize->add_section('shn_base_links', array(
        'title' => __('Links', 'shn-base'),
        'panel' => 'shn_base_options',
    ));

    // Colors settings
    $wp_customize->add_setting('shn_base_primary_color', array(
        'default' => '#007cba',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_primary_color', array(
        'label' => __('Primary Color', 'shn-base'),
        'section' => 'shn_base_colors',
    )));

    $wp_customize->add_setting('shn_base_secondary_color', array(
        'default' => '#333',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_secondary_color', array(
        'label' => __('Secondary Color', 'shn-base'),
        'section' => 'shn_base_colors',
    )));

    $wp_customize->add_setting('shn_base_text_color', array(
        'default' => '#333',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_text_color', array(
        'label' => __('Text Color', 'shn-base'),
        'section' => 'shn_base_colors',
    )));

    $wp_customize->add_setting('shn_base_background_color', array(
        'default' => '#fff',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_background_color', array(
        'label' => __('Background Color', 'shn-base'),
        'section' => 'shn_base_colors',
    )));

    // Typography settings
    $wp_customize->add_setting('shn_base_font_family', array(
        'default' => 'Arial, sans-serif',
        'sanitize_callback' => 'shn_base_sanitize_font_family',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control('shn_base_font_family', array(
        'label' => __('Font Family', 'shn-base'),
        'section' => 'shn_base_typography',
        'type' => 'select',
        'choices' => array(
            'Arial, sans-serif' => 'Arial',
            'Helvetica, sans-serif' => 'Helvetica',
            'Georgia, serif' => 'Georgia',
            'Times New Roman, serif' => 'Times New Roman',
            'Courier New, monospace' => 'Courier New',
            'Verdana, sans-serif' => 'Verdana',
            'Tahoma, sans-serif' => 'Tahoma',
        ),
    ));

    $wp_customize->add_setting('shn_base_font_size', array(
        'default' => '16px',
        'sanitize_callback' => 'shn_base_sanitize_font_size',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control('shn_base_font_size', array(
        'label' => __('Base Font Size', 'shn-base'),
        'section' => 'shn_base_typography',
        'type' => 'select',
        'choices' => array(
            '14px' => '14px',
            '16px' => '16px',
            '18px' => '18px',
            '20px' => '20px',
        ),
    ));

    // Heading settings
    $wp_customize->add_setting('shn_base_h1_color', array(
        'default' => '#333',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_h1_color', array(
        'label' => __('H1 Color', 'shn-base'),
        'section' => 'shn_base_headings',
    )));

    $wp_customize->add_setting('shn_base_h2_color', array(
        'default' => '#333',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_h2_color', array(
        'label' => __('H2 Color', 'shn-base'),
        'section' => 'shn_base_headings',
    )));

    $wp_customize->add_setting('shn_base_h3_color', array(
        'default' => '#333',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_h3_color', array(
        'label' => __('H3 Color', 'shn-base'),
        'section' => 'shn_base_headings',
    )));

    $wp_customize->add_setting('shn_base_h4_color', array(
        'default' => '#333',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_h4_color', array(
        'label' => __('H4 Color', 'shn-base'),
        'section' => 'shn_base_headings',
    )));

    $wp_customize->add_setting('shn_base_h5_color', array(
        'default' => '#333',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_h5_color', array(
        'label' => __('H5 Color', 'shn-base'),
        'section' => 'shn_base_headings',
    )));

    $wp_customize->add_setting('shn_base_h6_color', array(
        'default' => '#333',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_h6_color', array(
        'label' => __('H6 Color', 'shn-base'),
        'section' => 'shn_base_headings',
    )));

    $wp_customize->add_setting('shn_base_h2_font_size', array(
        'default' => '1.5em',
        'sanitize_callback' => 'shn_base_sanitize_heading_font_size',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control('shn_base_h2_font_size', array(
        'label' => __('H2 Font Size', 'shn-base'),
        'section' => 'shn_base_headings',
        'type' => 'select',
        'choices' => array(
            '1em' => '1em',
            '1.2em' => '1.2em',
            '1.5em' => '1.5em',
            '1.8em' => '1.8em',
        ),
    ));

    $wp_customize->add_setting('shn_base_h3_font_size', array(
        'default' => '1.17em',
        'sanitize_callback' => 'shn_base_sanitize_heading_font_size',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control('shn_base_h3_font_size', array(
        'label' => __('H3 Font Size', 'shn-base'),
        'section' => 'shn_base_headings',
        'type' => 'select',
        'choices' => array(
            '0.9em' => '0.9em',
            '1em' => '1em',
            '1.17em' => '1.17em',
            '1.3em' => '1.3em',
        ),
    ));

    $wp_customize->add_setting('shn_base_h4_font_size', array(
        'default' => '1em',
        'sanitize_callback' => 'shn_base_sanitize_heading_font_size',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control('shn_base_h4_font_size', array(
        'label' => __('H4 Font Size', 'shn-base'),
        'section' => 'shn_base_headings',
        'type' => 'select',
        'choices' => array(
            '0.8em' => '0.8em',
            '0.9em' => '0.9em',
            '1em' => '1em',
            '1.1em' => '1.1em',
        ),
    ));

    $wp_customize->add_setting('shn_base_h5_font_size', array(
        'default' => '0.83em',
        'sanitize_callback' => 'shn_base_sanitize_heading_font_size',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control('shn_base_h5_font_size', array(
        'label' => __('H5 Font Size', 'shn-base'),
        'section' => 'shn_base_headings',
        'type' => 'select',
        'choices' => array(
            '0.7em' => '0.7em',
            '0.8em' => '0.8em',
            '0.9em' => '0.9em',
            '1em' => '1em',
        ),
    ));

    $wp_customize->add_setting('shn_base_h6_font_size', array(
        'default' => '0.67em',
        'sanitize_callback' => 'shn_base_sanitize_heading_font_size',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control('shn_base_h6_font_size', array(
        'label' => __('H6 Font Size', 'shn-base'),
        'section' => 'shn_base_headings',
        'type' => 'select',
        'choices' => array(
            '0.6em' => '0.6em',
            '0.7em' => '0.7em',
            '0.8em' => '0.8em',
            '0.9em' => '0.9em',
        ),
    ));

    // Button settings
    $wp_customize->add_setting('shn_base_button_color', array(
        'default' => '#fff',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_button_color', array(
        'label' => __('Button Text Color', 'shn-base'),
        'section' => 'shn_base_buttons',
    )));

    $wp_customize->add_setting('shn_base_button_background_color', array(
        'default' => '#007cba',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_button_background_color', array(
        'label' => __('Button Background Color', 'shn-base'),
        'section' => 'shn_base_buttons',
    )));

    $wp_customize->add_setting('shn_base_button_hover_color', array(
        'default' => '#fff',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_button_hover_color', array(
        'label' => __('Button Hover Text Color', 'shn-base'),
        'section' => 'shn_base_buttons',
    )));

    $wp_customize->add_setting('shn_base_button_hover_background_color', array(
        'default' => '#005ea3',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_button_hover_background_color', array(
        'label' => __('Button Hover Background Color', 'shn-base'),
        'section' => 'shn_base_buttons',
    )));

    // Link settings
    $wp_customize->add_setting('shn_base_link_color', array(
        'default' => '#007cba',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_link_color', array(
        'label' => __('Link Color', 'shn-base'),
        'section' => 'shn_base_links',
    )));

    $wp_customize->add_setting('shn_base_link_hover_color', array(
        'default' => '#005ea3',
        'sanitize_callback' => 'sanitize_hex_color',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shn_base_link_hover_color', array(
        'label' => __('Link Hover Color', 'shn-base'),
        'section' => 'shn_base_links',
    )));
}
add_action('customize_register', 'shn_base_customize_register');

// Sanitize font family
function shn_base_sanitize_font_family($font)
{
    $valid_fonts = array(
        'Arial, sans-serif',
        'Helvetica, sans-serif',
        'Georgia, serif',
        'Times New Roman, serif',
        'Courier New, monospace',
        'Verdana, sans-serif',
        'Tahoma, sans-serif',
    );

    if (in_array($font, $valid_fonts)) {
        return $font;
    } else {
        return 'Arial, sans-serif';
    }
}

// Sanitize font size
function shn_base_sanitize_font_size($font_size)
{
    $valid_font_sizes = array(
        '14px',
        '16px',
        '18px',
        '20px',
    );

    if (in_array($font_size, $valid_font_sizes)) {
        return $font_size;
    } else {
        return '16px';
    }
}

// Sanitize heading font size
function shn_base_sanitize_heading_font_size($font_size)
{
    $valid_font_sizes = array(
        '0.6em',
        '0.67em',
        '0.7em',
        '0.8em',
        '0.83em',
        '0.9em',
        '1em',
        '1.1em',
        '1.17em',
        '1.2em',
        '1.3em',
        '1.5em',
        '1.8em',
        '2em',
        '2.5em',
        '3em',
    );

    if (in_array($font_size, $valid_font_sizes)) {
        return $font_size;
    } else {
        return '1em';
    }
}

// Output CSS based on customizer settings
function shn_base_customize_css()
{
?>
    <style type="text/css">
        body {
            font-family: <?php echo esc_attr(get_theme_mod('shn_base_font_family', 'Arial, sans-serif')); ?>;
            font-size: <?php echo esc_attr(get_theme_mod('shn_base_font_size', '16px')); ?>;
            color: <?php echo esc_attr(get_theme_mod('shn_base_text_color', '#333')); ?>;
            background-color: <?php echo esc_attr(get_theme_mod('shn_base_background_color', '#fff')); ?>;
            line-height: 1.6;
            margin: 0;
            padding: 0;
        }

        a {
            color: <?php echo esc_attr(get_theme_mod('shn_base_link_color', '#007cba')); ?>;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        a:hover,
        a:focus {
            color: <?php echo esc_attr(get_theme_mod('shn_base_link_hover_color', '#005ea3')); ?>;
        }

        h1 {
            font-size: <?php echo esc_attr(get_theme_mod('shn_base_h1_font_size', '2em')); ?>;
            color: <?php echo esc_attr(get_theme_mod('shn_base_h1_color', '#333')); ?>;
            margin: 0.67em 0;
        }

        h2 {
            font-size: <?php echo esc_attr(get_theme_mod('shn_base_h2_font_size', '1.5em')); ?>;
            color: <?php echo esc_attr(get_theme_mod('shn_base_h2_color', '#333')); ?>;
            margin: 0.83em 0;
        }

        h3 {
            font-size: <?php echo esc_attr(get_theme_mod('shn_base_h3_font_size', '1.17em')); ?>;
            color: <?php echo esc_attr(get_theme_mod('shn_base_h3_color', '#333')); ?>;
            margin: 1em 0;
        }

        h4 {
            font-size: <?php echo esc_attr(get_theme_mod('shn_base_h4_font_size', '1em')); ?>;
            color: <?php echo esc_attr(get_theme_mod('shn_base_h4_color', '#333')); ?>;
            margin: 1.33em 0;
        }

        h5 {
            font-size: <?php echo esc_attr(get_theme_mod('shn_base_h5_font_size', '0.83em')); ?>;
            color: <?php echo esc_attr(get_theme_mod('shn_base_h5_color', '#333')); ?>;
            margin: 1.67em 0;
        }

        h6 {
            font-size: <?php echo esc_attr(get_theme_mod('shn_base_h6_font_size', '0.67em')); ?>;
            color: <?php echo esc_attr(get_theme_mod('shn_base_h6_color', '#333')); ?>;
            margin: 2em 0;
        }

        p {
            margin: 1em 0;
            color: inherit;
        }

        ul,
        ol {
            margin: 1em 0;
            padding-left: 2em;
        }

        li {
            margin: 0.5em 0;
        }

        blockquote {
            margin: 1em 0;
            padding: 1em;
            border-left: 4px solid <?php echo esc_attr(get_theme_mod('shn_base_primary_color', '#007cba')); ?>;
            background-color: #f9f9f9;
            font-style: italic;
        }

        pre,
        code {
            font-family: 'Courier New', monospace;
            background-color: #f4f4f4;
            padding: 0.2em 0.4em;
            border-radius: 3px;
        }

        pre {
            padding: 1em;
            overflow-x: auto;
        }

        button,
        .btn,
        input[type="submit"],
        input[type="button"],
        input[type="reset"] {
            color: <?php echo esc_attr(get_theme_mod('shn_base_button_color', '#fff')); ?>;
            background-color: <?php echo esc_attr(get_theme_mod('shn_base_button_background_color', '#007cba')); ?>;
            border: none;
            padding: 0.75em 1.5em;
            border-radius: 4px;
            cursor: pointer;
            font-size: inherit;
            font-family: inherit;
            transition: all 0.3s ease;
            display: inline-block;
            text-decoration: none;
        }

        button:hover,
        .btn:hover,
        input[type="submit"]:hover,
        input[type="button"]:hover,
        input[type="reset"]:hover {
            color: <?php echo esc_attr(get_theme_mod('shn_base_button_hover_color', '#fff')); ?>;
            background-color: <?php echo esc_attr(get_theme_mod('shn_base_button_hover_background_color', '#005ea3')); ?>;
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }

        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="search"],
        input[type="url"],
        textarea,
        select {
            padding: 0.5em;
            border: 1px solid #ddd;
            border-radius: 3px;
            font-family: inherit;
            font-size: inherit;
            transition: border-color 0.3s ease;
        }

        input[type="text"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus,
        input[type="search"]:focus,
        input[type="url"]:focus,
        textarea:focus,
        select:focus {
            outline: none;
            border-color: <?php echo esc_attr(get_theme_mod('shn_base_primary_color', '#007cba')); ?>;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 1em 0;
        }

        th,
        td {
            padding: 0.75em;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        th {
            background-color: #f5f5f5;
            font-weight: bold;
        }

        img {
            max-width: 100%;
            height: auto;
        }

        .site-header,
        .site-footer {
            padding: 1em;
        }

        .site-main {
            padding: 1em;
        }
    </style>
<?php
}
add_action('wp_head', 'shn_base_customize_css');

// Enqueue customizer script
function shn_base_customize_preview_js()
{
    wp_enqueue_script('shn-base-customizer', get_template_directory_uri() . '/js/customizer.js', array('customize-preview'), '1.0', true);
}
add_action('customize_preview_init', 'shn_base_customize_preview_js');
