<?php

/**
 * The front page template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @package SHN-Base
 */

get_header(); ?>

<main id="primary" class="site-main">

    <?php if (have_posts()) : ?>

        <!-- Hero Section -->
        <section class="hero-section">
            <div class="hero-content">
                <h1 class="hero-title"><?php bloginfo('name'); ?></h1>
                <p class="hero-description"><?php bloginfo('description'); ?></p>
                <?php if (get_theme_mod('shn_base_hero_button_text')) : ?>
                    <a href="<?php echo esc_url(get_theme_mod('shn_base_hero_button_url', '#')); ?>" class="hero-button btn">
                        <?php echo esc_html(get_theme_mod('shn_base_hero_button_text')); ?>
                    </a>
                <?php endif; ?>
            </div>
        </section>

        <!-- Featured Posts Section -->
        <section class="featured-posts">
            <div class="container">
                <h2 class="section-title"><?php echo esc_html(get_theme_mod('shn_base_featured_title', 'Latest Posts')); ?></h2>
                <div class="posts-grid">
                    <?php
                    $featured_posts = new WP_Query(array(
                        'posts_per_page' => get_theme_mod('shn_base_featured_posts_count', 3),
                        'post_status' => 'publish',
                        'meta_query' => array(
                            array(
                                'key' => '_thumbnail_id',
                                'compare' => 'EXISTS'
                            )
                        )
                    ));

                    if ($featured_posts->have_posts()) :
                        while ($featured_posts->have_posts()) : $featured_posts->the_post();
                    ?>
                            <article id="post-<?php the_ID(); ?>" <?php post_class('featured-post'); ?>>
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="post-thumbnail">
                                        <a href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
                                            <?php the_post_thumbnail('medium', array('loading' => 'lazy', 'decoding' => 'async')); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <div class="post-content">
                                    <header class="entry-header">
                                        <?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
                                    </header>

                                    <div class="entry-meta">
                                        <span class="posted-on">
                                            <time class="entry-date published" datetime="<?php echo esc_attr(get_the_date('c')); ?>">
                                                <?php echo esc_html(get_the_date()); ?>
                                            </time>
                                        </span>
                                        <span class="byline">
                                            <?php _e('by', 'shn-base'); ?>
                                            <span class="author vcard">
                                                <a class="url fn n" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                    <?php echo esc_html(get_the_author()); ?>
                                                </a>
                                            </span>
                                        </span>
                                    </div>

                                    <div class="entry-summary">
                                        <?php the_excerpt(); ?>
                                    </div>

                                    <footer class="entry-footer">
                                        <a href="<?php the_permalink(); ?>" class="read-more">
                                            <?php _e('Read More', 'shn-base'); ?>
                                            <span class="screen-reader-text"><?php printf(__('about %s', 'shn-base'), get_the_title()); ?></span>
                                        </a>
                                    </footer>
                                </div>
                            </article>
                    <?php
                        endwhile;
                        wp_reset_postdata();
                    endif;
                    ?>
                </div>
            </div>
        </section>

        <!-- Call to Action Section -->
        <?php if (get_theme_mod('shn_base_cta_title') || get_theme_mod('shn_base_cta_description')) : ?>
            <section class="cta-section">
                <div class="container">
                    <div class="cta-content">
                        <?php if (get_theme_mod('shn_base_cta_title')) : ?>
                            <h2 class="cta-title"><?php echo esc_html(get_theme_mod('shn_base_cta_title')); ?></h2>
                        <?php endif; ?>

                        <?php if (get_theme_mod('shn_base_cta_description')) : ?>
                            <p class="cta-description"><?php echo esc_html(get_theme_mod('shn_base_cta_description')); ?></p>
                        <?php endif; ?>

                        <?php if (get_theme_mod('shn_base_cta_button_text')) : ?>
                            <a href="<?php echo esc_url(get_theme_mod('shn_base_cta_button_url', '#')); ?>" class="cta-button btn">
                                <?php echo esc_html(get_theme_mod('shn_base_cta_button_text')); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </section>
        <?php endif; ?>

        <!-- Recent Posts Section -->
        <section class="recent-posts">
            <div class="container">
                <h2 class="section-title"><?php echo esc_html(get_theme_mod('shn_base_recent_title', 'Recent Posts')); ?></h2>
                <div class="posts-list">
                    <?php
                    while (have_posts()) :
                        the_post();
                    ?>
                        <article id="post-<?php the_ID(); ?>" <?php post_class('recent-post'); ?>>
                            <div class="post-content">
                                <header class="entry-header">
                                    <?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
                                </header>

                                <div class="entry-meta">
                                    <span class="posted-on">
                                        <time class="entry-date published" datetime="<?php echo esc_attr(get_the_date('c')); ?>">
                                            <?php echo esc_html(get_the_date()); ?>
                                        </time>
                                    </span>
                                    <span class="byline">
                                        <?php _e('by', 'shn-base'); ?>
                                        <span class="author vcard">
                                            <a class="url fn n" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                <?php echo esc_html(get_the_author()); ?>
                                            </a>
                                        </span>
                                    </span>
                                </div>

                                <div class="entry-summary">
                                    <?php the_excerpt(); ?>
                                </div>

                                <footer class="entry-footer">
                                    <a href="<?php the_permalink(); ?>" class="read-more">
                                        <?php _e('Read More', 'shn-base'); ?>
                                        <span class="screen-reader-text"><?php printf(__('about %s', 'shn-base'), get_the_title()); ?></span>
                                    </a>
                                </footer>
                            </div>

                            <?php if (has_post_thumbnail()) : ?>
                                <div class="post-thumbnail">
                                    <a href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
                                        <?php the_post_thumbnail('thumbnail', array('loading' => 'lazy', 'decoding' => 'async')); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </article>
                    <?php
                    endwhile;
                    ?>
                </div>

                <!-- Pagination -->
                <nav class="navigation pagination" role="navigation" aria-label="<?php esc_attr_e('Posts', 'shn-base'); ?>">
                    <h2 class="screen-reader-text"><?php _e('Posts navigation', 'shn-base'); ?></h2>
                    <div class="nav-links">
                        <?php
                        echo paginate_links(array(
                            'mid_size' => 2,
                            'prev_text' => __('&laquo; Previous', 'shn-base'),
                            'next_text' => __('Next &raquo;', 'shn-base'),
                        ));
                        ?>
                    </div>
                </nav>
            </div>
        </section>

    <?php else : ?>

        <!-- No Posts Found -->
        <section class="no-results not-found">
            <div class="container">
                <header class="page-header">
                    <h1 class="page-title"><?php _e('Nothing here', 'shn-base'); ?></h1>
                </header>

                <div class="page-content">
                    <?php if (is_home() && current_user_can('publish_posts')) : ?>
                        <p>
                            <?php
                            printf(
                                wp_kses(
                                    __('Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'shn-base'),
                                    array(
                                        'a' => array(
                                            'href' => array(),
                                        ),
                                    )
                                ),
                                esc_url(admin_url('post-new.php'))
                            );
                            ?>
                        </p>
                    <?php elseif (is_search()) : ?>
                        <p><?php _e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'shn-base'); ?></p>
                        <?php get_search_form(); ?>
                    <?php else : ?>
                        <p><?php _e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'shn-base'); ?></p>
                        <?php get_search_form(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </section>

    <?php endif; ?>

</main>

<?php
get_sidebar();
get_footer();
?>