<?php
// SEO Optimizations
function shn_base_seo_meta()
{
    if (is_single() || is_page()) {
        global $post;

        // Meta description
        $excerpt = wp_trim_words(strip_tags($post->post_content), 25, '...');
        echo '<meta name="description" content="' . esc_attr($excerpt) . '">' . "\n";

        // Open Graph tags
        echo '<meta property="og:title" content="' . esc_attr(get_the_title()) . '">' . "\n";
        echo '<meta property="og:description" content="' . esc_attr($excerpt) . '">' . "\n";
        echo '<meta property="og:url" content="' . esc_url(get_permalink()) . '">' . "\n";
        echo '<meta property="og:type" content="article">' . "\n";

        // Featured image for Open Graph
        if (has_post_thumbnail()) {
            $image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
            echo '<meta property="og:image" content="' . esc_url($image[0]) . '">' . "\n";
        }

        // Twitter Card
        echo '<meta name="twitter:card" content="summary_large_image">' . "\n";
        echo '<meta name="twitter:title" content="' . esc_attr(get_the_title()) . '">' . "\n";
        echo '<meta name="twitter:description" content="' . esc_attr($excerpt) . '">' . "\n";
    }
}
add_action('wp_head', 'shn_base_seo_meta');

// Structured data for SEO
function shn_base_structured_data()
{
    if (is_single()) {
        global $post;

        $schema = array(
            '@context' => 'https://schema.org',
            '@type' => 'Article',
            'headline' => get_the_title(),
            'author' => array(
                '@type' => 'Person',
                'name' => get_the_author()
            ),
            'datePublished' => get_the_date('c'),
            'dateModified' => get_the_modified_date('c'),
            'description' => wp_trim_words(strip_tags($post->post_content), 25, '...'),
            'url' => get_permalink()
        );

        if (has_post_thumbnail()) {
            $image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
            $schema['image'] = $image[0];
        }

        echo '<script type="application/ld+json">' . json_encode($schema) . '</script>' . "\n";
    }
}
add_action('wp_head', 'shn_base_structured_data');

// Optimize images
function shn_base_image_optimization($attr, $attachment, $size)
{
    $attr['loading'] = 'lazy';
    $attr['decoding'] = 'async';
    return $attr;
}
add_filter('wp_get_attachment_image_attributes', 'shn_base_image_optimization', 10, 3);

// Add critical resource hints
function shn_base_resource_hints()
{
    echo '<link rel="preconnect" href="https://fonts.googleapis.com">' . "\n";
    echo '<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>' . "\n";
    echo '<link rel="dns-prefetch" href="//www.google-analytics.com">' . "\n";
}
add_action('wp_head', 'shn_base_resource_hints', 1);

// Custom excerpt length
function shn_base_excerpt_length($length)
{
    return 25;
}
add_filter('excerpt_length', 'shn_base_excerpt_length');
