<?php
/**
 * Hero Section Block Template
 * 
 * Available variables:
 * $fields - ACF fields array
 * $is_preview - Whether this is a preview
 * $post_id - Current post ID
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$title = $fields['title'] ?? 'Welcome to Our Website';
$subtitle = $fields['subtitle'] ?? '';
$abstract = $fields['abstract'] ?? '';
$background_color = $fields['background_color'] ?? '#f0f0f0';

if (isset($fields['buttons_repeater']['icon'])) {
    $icon = $fields['buttons_repeater']['icon'] ?? '';
}

$cta_title    = $fields['cta']['title'] ?? '';
$cta_subtitle = $fields['cta']['subtitle'] ?? '';

$cta_image        = $fields['cta']['image'] ?? null;
$cta_image_url    = $cta_image['url'] ?? '';
$cta_image_alt    = $cta_image['alt'] ?? '';

$cta_button       = $fields['cta']['button'] ?? null;
$cta_button_text  = $cta_button['title'] ?? 'Click Here';
$cta_button_url   = $cta_button['url'] ?? '#';
$cta_button_target= $cta_button['target'] ?? '_self';
?>

<div class="hero-section" 
     style="background-color: <?php echo esc_attr($background_color); ?>;"
     <?php if ($is_preview): ?>data-mode="preview"<?php endif; ?>>
    <div class="container">
        <!-- Left Section -->
        <div class="left-section">
            <h1 class="main-title">
                <?php echo esc_html($title); ?>
            </h1>

            <p class="subtitle">
                <?php echo esc_html($subtitle); ?>
            </p>

            <div class="description">
            <?php echo $abstract; ?>
            </div>

            <div class="action-buttons">
                <?php if (have_rows('buttons_repeater')): ?>
                    <?php while (have_rows('buttons_repeater')): the_row(); 
                        $button = get_sub_field('button');
                        $icon   = get_sub_field('icon');

                        $button_text   = $button['title'] ?? 'Learn More';
                        $button_url    = $button['url'] ?? '#';
                        $button_target = $button['target'] ?? '_self';
                    ?>
                        <a class="action-btn" 
                        href="<?php echo esc_url($button_url); ?>" 
                        target="<?php echo esc_attr($button_target); ?>">

                            <?php if (!empty($icon) && isset($icon['type'], $icon['value'])): ?>
                                
                                <?php if ($icon['type'] === 'dashicons'): ?>
                                    <span class="<?php echo esc_attr($icon['value']); ?>"></span>

                                <?php elseif ($icon['type'] === 'media_library'): ?>
                                    <?php 
                                        $attachment_id = intval($icon['value']);
                                        echo wp_get_attachment_image($attachment_id, 'full'); 
                                    ?>

                                <?php elseif ($icon['type'] === 'url'): ?>
                                    <img src="<?php echo esc_url($icon['value']); ?>" alt="icon">
                                <?php endif; ?>

                            <?php endif; ?>

                            <?php echo esc_html($button_text); ?>
                        </a>
                    <?php endwhile; ?>
                <?php endif; ?>
            </div>

        </div>

        <!-- Right Section -->
        <div class="right-section">
            <div class="right-section-wrapper">
                <h2 class="offer-title">
                    <?php echo esc_html($cta_title); ?>
                </h2>
                <p class="offer-subtitle">
                    <?php echo esc_html($cta_subtitle); ?>
                </p>
                <?php if ($cta_image_url): ?>
                    <div class="cta-image">
                        <img src="<?php echo esc_url($cta_image_url); ?>" 
                                alt="<?php echo esc_attr($cta_image_alt); ?>">
                    </div>
                <?php endif; ?>
                
                <?php if ($cta_button_url): ?>
                    <a class="cta-button" 
                    href="<?php echo esc_url($cta_button_url); ?>" 
                    target="<?php echo esc_attr($cta_button_target); ?>">

                    <?php echo esc_html($cta_button_text); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>  
</div>
