/**
 * Testimonials Block JavaScript
 * Enhances the preview/edit mode toggle experience
 */

(function() {
    'use strict';
    
    // Wait for DOM to be ready
    document.addEventListener('DOMContentLoaded', function() {
        // Find all testimonials section blocks
        const testimonialBlocks = document.querySelectorAll('.testimonials-section');
        
        testimonialBlocks.forEach(function(block) {
            // Add a subtle animation when switching to preview mode
            if (block.hasAttribute('data-mode')) {
                block.style.transition = 'all 0.3s ease';
                
                // Add a subtle pulse animation to indicate preview mode
                block.style.animation = 'testimonialPreviewPulse 2s ease-in-out infinite';
            }
        });
    });
    
    // Add CSS animation for preview mode
    const style = document.createElement('style');
    style.textContent = `
        @keyframes testimonialPreviewPulse {
            0%, 100% { 
                box-shadow: 0 0 0 0 rgba(0, 123, 255, 0.4);
            }
            50% { 
                box-shadow: 0 0 0 10px rgba(0, 123, 255, 0);
            }
        }
        
        .testimonials-section[data-mode="preview"] {
            border: 2px solid rgba(0, 123, 255, 0.3);
            border-radius: 8px;
        }
    `;
    document.head.appendChild(style);
    
})();
