<?php
/**
 * Hero Section Block Configuration
 */

function smarter_blocks_hero_section_config() {
    return [
        'name' => 'hero-section',
        'title' => 'Hero Section',
        'description' => 'A customizable hero section with title, subtitle, description, and CTA.',
        'category' => 'formatting',
        'icon' => 'align-wide',
        'keywords' => ['hero', 'section', 'banner', 'header'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'title' => 'Welcome to Our Website',
                    'subtitle' => 'Your trusted partner',
                    'abstract' => 'We provide innovative solutions for your business needs.',
                    'background_color' => '#000000',
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
