<?php
/**
 * Pricing Cards Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_pricing_cards',
    'title' => 'Pricing Cards',
    'fields' => [
        [
            'key' => 'field_pricing_cards_repeater',
            'label' => 'Pricing Cards',
            'name' => 'pricing_cards',
            'type' => 'repeater',
            'layout' => 'block',
            'required' => 1,
            'min' => 1,
            'max' => 3,
            'button_label' => 'Add Pricing Card',
            'sub_fields' => [
                [
                    'key' => 'field_badge_group',
                    'label' => 'Badge Settings',
                    'name' => 'badge_group',
                    'type' => 'group',
                    'layout' => 'block',
                    'sub_fields' => [
                        [
                            'key' => 'field_most_popular',
                            'label' => 'Most Popular',
                            'name' => 'most_popular',
                            'type' => 'true_false',
                            'required' => 0,
                            'default_value' => 0,
                            'ui' => 1,
                            'ui_on_text' => 'Yes',
                            'ui_off_text' => 'No',
                        ],
                        [
                            'key' => 'field_badge_text',
                            'label' => 'Badge Text',
                            'name' => 'badge_text',
                            'type' => 'text',
                            'required' => 1,
                            'default_value' => 'Badge Text',
                            'placeholder' => 'Enter badge text',
                        ],
                        [
                            'key' => 'field_badge_text_color',
                            'label' => 'Badge Text Color',
                            'name' => 'badge_text_color',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#ffffff',
                            'return_format' => 'string',
                        ],
                        [
                            'key' => 'field_badge_color_type',
                            'label' => 'Badge Background Type',
                            'name' => 'badge_color_type',
                            'type' => 'select',
                            'required' => 0,
                            'default_value' => 'solid',
                            'choices' => [
                                'solid' => 'Color Sólido',
                                'gradient' => 'Gradiente',
                            ],
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                        ],
                        [
                            'key' => 'field_badge_color_solid',
                            'label' => 'Badge Background Color (Sólido)',
                            'name' => 'badge_color_solid',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#ff6b35',
                            'return_format' => 'string',
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'field_badge_color_type',
                                        'operator' => '==',
                                        'value' => 'solid',
                                    ],
                                ],
                            ],
                        ],
                        [
                            'key' => 'field_badge_color_gradient',
                            'label' => 'Badge Background Color (Gradiente)',
                            'name' => 'badge_color_gradient',
                            'type' => 'text',
                            'required' => 0,
                            'default_value' => 'linear-gradient(135deg, #ff6b35 0%, #f7931e 100%)',
                            'placeholder' => 'linear-gradient(135deg, #ff6b35 0%, #f7931e 100%)',
                            'instructions' => 'Ingresa un gradiente CSS válido. Ejemplos:<br>
                            • linear-gradient(135deg, #ff6b35 0%, #f7931e 100%)<br>
                            • radial-gradient(circle, #ff6b35 0%, #f7931e 100%)<br>
                            • linear-gradient(45deg, #ff6b35, #f7931e, #ff6b35)',
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'field_badge_color_type',
                                        'operator' => '==',
                                        'value' => 'gradient',
                                    ],
                                ],
                            ],
                        ],
                        [
                            'key' => 'field_badge_icon',
                            'label' => 'Badge Icon (SVG Code)',
                            'name' => 'badge_icon',
                            'type' => 'textarea',
                            'required' => 0,
                            'default_value' => '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star h-3 w-3"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>',
                            'placeholder' => 'Pega aquí el código SVG del icono que quieres usar',
                            'rows' => 4,
                        ],
                    ],
                ],
                [
                    'key' => 'field_card_group',
                    'label' => 'Card Settings',
                    'name' => 'card_group',
                    'type' => 'group',
                    'layout' => 'block',
                    'sub_fields' => [
                        [
                            'key' => 'field_card_background',
                            'label' => 'Card Background Color',
                            'name' => 'card_background',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#ffffff',
                            'return_format' => 'string',
                        ],
                        [
                            'key' => 'field_card_title_color',
                            'label' => 'Title Color',
                            'name' => 'card_title_color',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#1e293b',
                            'return_format' => 'string',
                        ],
                        [
                            'key' => 'field_card_subtitle_color',
                            'label' => 'Subtitle Color',
                            'name' => 'card_subtitle_color',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#64748b',
                            'return_format' => 'string',
                        ],
                        [
                            'key' => 'field_card_price_color',
                            'label' => 'Price Color',
                            'name' => 'card_price_color',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#1e293b',
                            'return_format' => 'string',
                        ],
                        [
                            'key' => 'field_card_period_color',
                            'label' => 'Price Period Color',
                            'name' => 'card_period_color',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#64748b',
                            'return_format' => 'string',
                        ],
                        [
                            'key' => 'field_card_description_color',
                            'label' => 'Description Color',
                            'name' => 'card_description_color',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#64748b',
                            'return_format' => 'string',
                        ],
                        [
                            'key' => 'field_card_features_color',
                            'label' => 'Features Text Color',
                            'name' => 'card_features_color',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#1e293b',
                            'return_format' => 'string',
                        ],
                        [
                            'key' => 'field_card_title',
                            'label' => 'Title',
                            'name' => 'title',
                            'type' => 'text',
                            'required' => 1,
                            'default_value' => 'Plan Name',
                            'placeholder' => 'Enter plan title',
                        ],
                        [
                            'key' => 'field_card_subtitle',
                            'label' => 'Subtitle',
                            'name' => 'subtitle',
                            'type' => 'text',
                            'required' => 0,
                            'placeholder' => 'Enter plan subtitle (optional)',
                        ],
                        [
                            'key' => 'field_card_price',
                            'label' => 'Price',
                            'name' => 'price',
                            'type' => 'number',
                            'required' => 1,
                            'default_value' => 0,
                            'min' => 0,
                            'step' => 0.01,
                            'placeholder' => '0.00',
                        ],
                        [
                            'key' => 'field_card_price_period',
                            'label' => 'Price Period',
                            'name' => 'price_period',
                            'type' => 'text',
                            'required' => 0,
                            'default_value' => '/month',
                            'placeholder' => '/month, /year, /forever, etc.',
                        ],
                        [
                            'key' => 'field_card_description',
                            'label' => 'Description',
                            'name' => 'description',
                            'type' => 'text',
                            'required' => 0,
                            'placeholder' => 'Enter plan description',
                        ],
                        [
                            'key' => 'field_card_list',
                            'label' => 'Features List',
                            'name' => 'list',
                            'type' => 'repeater',
                            'layout' => 'block',
                            'required' => 0,
                            'min' => 0,
                            'button_label' => 'Add Feature',
                            'sub_fields' => [
                                [
                                    'key' => 'field_list_option',
                                    'label' => 'Feature',
                                    'name' => 'list_option',
                                    'type' => 'text',
                                    'required' => 1,
                                    'placeholder' => 'Enter feature description',
                                ],
                                [
                                    'key' => 'field_list_icon',
                                    'label' => 'Feature Icon (SVG Code)',
                                    'name' => 'list_icon',
                                    'type' => 'textarea',
                                    'required' => 0,
                                    'default_value' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check h-4 w-4 text-accent shrink-0"><path d="M20 6 9 17l-5-5"></path></svg>',
                                    'placeholder' => 'Pega aquí el código SVG del icono que quieres usar para esta feature',
                                    'rows' => 4,
                                ],
                            ],
                        ],
                    ],
                ],
                [
                    'key' => 'field_button_group',
                    'label' => 'Button Settings',
                    'name' => 'button_group',
                    'type' => 'group',
                    'layout' => 'block',
                    'sub_fields' => [
                        [
                            'key' => 'field_card_cta',
                            'label' => 'Call to Action',
                            'name' => 'cta',
                            'type' => 'link',
                            'required' => 1,
                            'return_format' => 'array',
                        ],
                        [
                            'key' => 'field_button_text',
                            'label' => 'Button Text',
                            'name' => 'button_text',
                            'type' => 'text',
                            'required' => 0,
                            'default_value' => 'Get Started',
                            'placeholder' => 'Enter button text',
                        ],
                        [
                            'key' => 'field_button_text_color',
                            'label' => 'Button Text Color',
                            'name' => 'button_text_color',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#ffffff',
                            'return_format' => 'string',
                        ],
                        [
                            'key' => 'field_button_color_type',
                            'label' => 'Button Background Type',
                            'name' => 'button_color_type',
                            'type' => 'select',
                            'required' => 0,
                            'default_value' => 'solid',
                            'choices' => [
                                'solid' => 'Color Sólido',
                                'gradient' => 'Gradiente',
                            ],
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                        ],
                        [
                            'key' => 'field_button_color_solid',
                            'label' => 'Button Background Color (Sólido)',
                            'name' => 'button_color_solid',
                            'type' => 'color_picker',
                            'required' => 0,
                            'default_value' => '#0ea5e9',
                            'return_format' => 'string',
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'field_button_color_type',
                                        'operator' => '==',
                                        'value' => 'solid',
                                    ],
                                ],
                            ],
                        ],
                        [
                            'key' => 'field_button_color_gradient',
                            'label' => 'Button Background Color (Gradiente)',
                            'name' => 'button_color_gradient',
                            'type' => 'text',
                            'required' => 0,
                            'default_value' => 'linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%)',
                            'placeholder' => 'linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%)',
                            'instructions' => 'Ingresa un gradiente CSS válido para el botón. Ejemplos:<br>
                            • linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%)<br>
                            • radial-gradient(circle, #0ea5e9 0%, #0284c7 100%)<br>
                            • linear-gradient(45deg, #0ea5e9, #0284c7, #0ea5e9)',
                            'conditional_logic' => [
                                [
                                    [
                                        'field' => 'field_button_color_type',
                                        'operator' => '==',
                                        'value' => 'gradient',
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/pricing-cards',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'layout' => 'vertical',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure up to 3 pricing cards with features and CTAs.',
]);
