<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$pricing_cards = $fields['pricing_cards'] ?? [];
?>

<div class="pricing-cards-container">
    <div class="pricing-cards-grid">
        <?php if (have_rows('pricing_cards')): ?>
            <?php while (have_rows('pricing_cards')): the_row(); 
                // Obtener datos del grupo del badge
                $badge_group = get_sub_field('badge_group');
                $most_popular = $badge_group['most_popular'] ?? false;
                $badge_text = $badge_group['badge_text'] ?? 'Badge Text';
                
                // Configuración del color de fondo del badge
                $badge_color_type = $badge_group['badge_color_type'] ?? 'solid';
                $badge_color_solid = $badge_group['badge_color_solid'] ?? '#ff6b35';
                $badge_color_gradient = $badge_group['badge_color_gradient'] ?? 'linear-gradient(135deg, #ff6b35 0%, #f7931e 100%)';
                
                // Configuración del color del texto del badge
                $badge_text_color = $badge_group['badge_text_color'] ?? '#ffffff';
                
                // Determinar el color final del badge
                $badge_color = ($badge_color_type === 'gradient') ? $badge_color_gradient : $badge_color_solid;
                
                $badge_icon = $badge_group['badge_icon'] ?? '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star h-3 w-3"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>';
                
                // Obtener datos del grupo de la tarjeta
                $card_group = get_sub_field('card_group');
                $card_background = $card_group['card_background'] ?? '#ffffff';
                $card_title_color = $card_group['card_title_color'] ?? '#1e293b';
                $card_subtitle_color = $card_group['card_subtitle_color'] ?? '#64748b';
                $card_price_color = $card_group['card_price_color'] ?? '#1e293b';
                $card_period_color = $card_group['card_period_color'] ?? '#64748b';
                $card_description_color = $card_group['card_description_color'] ?? '#64748b';
                $card_features_color = $card_group['card_features_color'] ?? '#1e293b';
                $title = $card_group['title'];
                $subtitle = $card_group['subtitle'];
                $price = $card_group['price'];
                $price_period = $card_group['price_period'] ?? '/month';
                $description = $card_group['description'];
                
                // Obtener datos del grupo del botón
                $button_group = get_sub_field('button_group');
                $button_text = $button_group['button_text'] ?? 'Get Started';
                $button_text_color = $button_group['button_text_color'] ?? '#ffffff';
                $button_color_type = $button_group['button_color_type'] ?? 'solid';
                $button_color_solid = $button_group['button_color_solid'] ?? '#0ea5e9';
                $button_color_gradient = $button_group['button_color_gradient'] ?? 'linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%)';
                $cta = $button_group['cta'];
                
                // Determinar el color final del botón
                $button_color = ($button_color_type === 'gradient') ? $button_color_gradient : $button_color_solid;
                
                $cta_title = $button_text ?: ($cta['title'] ?? 'Get Started');
                $cta_url = $cta['url'] ?? '#';
                $cta_target = $cta['target'] ?? '_self';
            ?>
                <div class="pricing-card <?php echo $most_popular ? 'most-popular' : ''; ?>" style="--custom-card-bg: <?php echo esc_attr($card_background); ?>; background-color: <?php echo esc_attr($card_background); ?>;">
                    <?php if ($most_popular): ?>
                        <div class="popular-badge" style="--custom-badge-color: <?php echo esc_attr($badge_color); ?>; background: <?php echo esc_attr($badge_color); ?>;">
                            <span class="star-icon" style="color: <?php echo esc_attr($badge_text_color); ?>;">
                                <?php echo $badge_icon; ?>
                            </span>
                            <span class="badge-text" style="color: <?php echo esc_attr($badge_text_color); ?>;"><?php echo esc_html($badge_text); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <div class="card-content">
                        <p class="card-title" style="color: <?php echo esc_attr($card_title_color); ?>;"><?php echo esc_html($title); ?></p>
                        
                        <?php if ($subtitle): ?>
                            <p class="card-subtitle" style="color: <?php echo esc_attr($card_subtitle_color); ?>;"><?php echo esc_html($subtitle); ?></p>
                        <?php endif; ?>
                        
                        <div class="price-section">
                            <span class="price" style="color: <?php echo esc_attr($card_price_color); ?>;">$<?php echo esc_html(number_format($price, 0)); ?></span>
                            <span class="price-period" style="color: <?php echo esc_attr($card_period_color); ?>;">
                                <?php echo esc_html($price_period); ?>
                            </span>
                        </div>
                        
                        <?php if ($description): ?>
                            <p class="card-description" style="color: <?php echo esc_attr($card_description_color); ?>;"><?php echo esc_html($description); ?></p>
                        <?php endif; ?>
                        
                        <ul class="features-list">
                            <?php if (!empty($card_group['list']) && is_array($card_group['list'])): ?>
                                <?php foreach ($card_group['list'] as $feature): ?>
                                    <li class="feature-item">
                                        <span class="check-icon">
                                            <?php echo $feature['list_icon'] ?? '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check h-4 w-4 text-accent shrink-0"><path d="M20 6 9 17l-5-5"></path></svg>'; ?>
                                        </span>
                                        <span class="feature-text" style="color: <?php echo esc_attr($card_features_color); ?>;"><?php echo esc_html($feature['list_option']); ?></span>
                                    </li>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </ul>
                        
                        <a href="<?php echo esc_url($cta_url); ?>" 
                           target="<?php echo esc_attr($cta_target); ?>" 
                           class="cta-button <?php echo $most_popular ? 'primary' : 'secondary'; ?>"
                           style="--custom-button-color: <?php echo esc_attr($button_color); ?>; background: <?php echo esc_attr($button_color); ?>; color: <?php echo esc_attr($button_text_color); ?>;">
                            <?php echo esc_html($cta_title); ?>
                        </a>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php endif; ?>
    </div>
</div>
