<?php
/**
 * Testimonials Block ACF Fields
 */

add_action('acf/init', function() {
    if (!function_exists('acf_add_local_field_group')) {
        return;
    }

    acf_add_local_field_group([
        'key' => 'group_testimonials',
        'title' => 'Testimonials',
        'fields' => [
            [
                'key' => 'field_testimonials_title',
                'label' => 'Section Title',
                'name' => 'title',
                'type' => 'text',
                'required' => 1,
                'default_value' => 'What Our Customers Say',
            ],
            [
                'key' => 'field_testimonials_subtitle',
                'label' => 'Section Subtitle',
                'name' => 'subtitle',
                'type' => 'textarea',
                'required' => 0,
                'rows' => 2,
            ],
            [
                'key' => 'field_testimonials_background_color',
                'label' => 'Background Color',
                'name' => 'background_color',
                'type' => 'color_picker',
                'required' => 0,
                'default_value' => '#f8f9fa',
            ],
            [
                'key' => 'field_testimonials_layout',
                'label' => 'Layout',
                'name' => 'layout',
                'type' => 'select',
                'required' => 0,
                'choices' => [
                    'grid' => 'Grid (3 columns)',
                    'slider' => 'Slider',
                    'list' => 'List (1 column)',
                ],
                'default_value' => 'grid',
            ],
            [
                'key' => 'field_testimonials_items',
                'label' => 'Testimonials',
                'name' => 'testimonials',
                'type' => 'repeater',
                'required' => 1,
                'min' => 1,
                'max' => 6,
                'layout' => 'block',
                'button_label' => 'Add Testimonial',
                'sub_fields' => [
                    [
                        'key' => 'field_testimonial_content',
                        'label' => 'Testimonial Content',
                        'name' => 'content',
                        'type' => 'textarea',
                        'required' => 1,
                        'rows' => 4,
                        'placeholder' => 'Enter the customer testimonial...',
                    ],
                    [
                        'key' => 'field_testimonial_name',
                        'label' => 'Customer Name',
                        'name' => 'name',
                        'type' => 'text',
                        'required' => 1,
                    ],
                    [
                        'key' => 'field_testimonial_position',
                        'label' => 'Position/Company',
                        'name' => 'position',
                        'type' => 'text',
                        'required' => 0,
                    ],
                    [
                        'key' => 'field_testimonial_rating',
                        'label' => 'Rating',
                        'name' => 'rating',
                        'type' => 'number',
                        'required' => 0,
                        'min' => 1,
                        'max' => 5,
                        'default_value' => 5,
                        'step' => 1,
                    ],
                    [
                        'key' => 'field_testimonial_avatar',
                        'label' => 'Avatar',
                        'name' => 'avatar',
                        'type' => 'image',
                        'required' => 0,
                        'return_format' => 'array',
                        'preview_size' => 'thumbnail',
                        'library' => 'all',
                    ],
                ],
            ],
        ],
        'location' => [
            [
                [
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/testimonials',
                ],
            ],
        ],
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ]);
});
