<?php
/**
 * Pricing Cards Block Configuration
 */

function smarter_blocks_pricing_cards_config() {
    return [
        'name' => 'pricing-cards',
        'title' => 'Pricing Cards',
        'description' => 'A pricing cards section with up to 3 cards, featuring most popular badge, pricing, features list, and CTA.',
        'category' => 'formatting',
        'icon' => 'money-alt',
        'keywords' => ['pricing', 'cards', 'plans', 'subscription', 'pricing-table'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'pricing_cards' => [
                        [
                            'most_popular' => false,
                            'badge_text' => 'Free',
                            'badge_color' => '#ff6b35',
                            'badge_icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star h-3 w-3"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>',
                            'card_background' => '#ffffff',
                            'card_text_color' => '#1e293b',
                            'title' => 'Free',
                            'price' => 0,
                            'description' => 'Get started with daily picks',
                            'list' => [
                                ['list_option' => '1 free pick daily'],
                                ['list_option' => 'Basic analysis'],
                                ['list_option' => 'Email delivery'],
                                ['list_option' => 'Community access']
                            ],
                            'cta' => [
                                'title' => 'Get Free Pick',
                                'url' => '#',
                                'target' => '_self'
                            ],
                            'button_text' => 'Get Free Pick',
                            'button_color' => '#10b981'
                        ],
                        [
                            'most_popular' => true,
                            'badge_text' => 'Most Popular',
                            'badge_color' => '#ff6b35',
                            'badge_icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star h-3 w-3"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>',
                            'card_background' => '#f8fafc',
                            'card_text_color' => '#1e293b',
                            'title' => 'Starter',
                            'price' => 25,
                            'description' => 'Perfect for casual bettors',
                            'list' => [
                                ['list_option' => 'All free features'],
                                ['list_option' => '5 premium picks daily'],
                                ['list_option' => 'Advanced analytics'],
                                ['list_option' => 'SMS notifications'],
                                ['list_option' => 'Handicapper insights'],
                                ['list_option' => 'Betting calculator']
                            ],
                            'cta' => [
                                'title' => 'Start 7-Day Trial',
                                'url' => '#',
                                'target' => '_self'
                            ],
                            'button_text' => 'Start 7-Day Trial',
                            'button_color' => '#3b82f6'
                        ],
                        [
                            'most_popular' => false,
                            'badge_text' => 'Premium',
                            'badge_color' => '#ff6b35',
                            'badge_icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star h-3 w-3"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>',
                            'card_background' => '#1e293b',
                            'card_text_color' => '#ffffff',
                            'title' => 'Premium',
                            'price' => 85,
                            'description' => 'For serious bettors',
                            'list' => [
                                ['list_option' => 'All starter features'],
                                ['list_option' => 'Unlimited picks'],
                                ['list_option' => 'Real-time alerts'],
                                ['list_option' => 'VIP Discord access'],
                                ['list_option' => 'Personal handicapper'],
                                ['list_option' => 'Advanced tools'],
                                ['list_option' => 'Priority support'],
                                ['list_option' => 'Exclusive content']
                            ],
                            'cta' => [
                                'title' => 'Go Premium',
                                'url' => '#',
                                'target' => '_self'
                            ],
                            'button_text' => 'Go Premium',
                            'button_color' => '#8b5cf6'
                        ]
                    ]
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
