// Password toggle functionality and form validation
document.addEventListener('DOMContentLoaded', function() {
    const toggleButtons = document.querySelectorAll('.toggle-password');
    const submitButton = document.querySelector('.submit-button');
    const emailInput = document.querySelector('input[type="email"]');
    const passwordInput = document.querySelector('input[type="password"], input[type="text"]');
    const termsCheckbox = document.querySelector('input[type="checkbox"]');
    
    // Password toggle functionality
    toggleButtons.forEach(button => {
        button.addEventListener('click', function() {
            const passwordField = this.parentElement.querySelector('input[type="password"], input[type="text"]');
            const eyeIcon = this.querySelector('.eye-icon');
            
            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                // Change to "eye closed" icon
                eyeIcon.innerHTML = `
                    <path d="M2.5 10C2.5 10 5 5 10 5C15 5 17.5 10 17.5 10C17.5 10 15 15 10 15C5 15 2.5 10 2.5 10Z" stroke="currentColor" stroke-width="1.5"/>
                    <path d="M3 3l14 14" stroke="currentColor" stroke-width="1.5"/>
                `;
            } else {
                passwordField.type = 'password';
                // Change back to "eye open" icon
                eyeIcon.innerHTML = `
                    <path d="M2.5 10C2.5 10 5 5 10 5C15 5 17.5 10 17.5 10C17.5 10 15 15 10 15C5 15 2.5 10 2.5 10Z" stroke="currentColor" stroke-width="1.5"/>
                    <circle cx="10" cy="10" r="2.5" stroke="currentColor" stroke-width="1.5"/>
                `;
            }
        });
    });
    
    // Form validation and button color change
    function checkFormValidity() {
        if (emailInput && passwordInput && termsCheckbox && submitButton) {
            const isEmailValid = emailInput.value.trim() !== '';
            const isPasswordValid = passwordInput.value.trim() !== '';
            const isTermsChecked = termsCheckbox.checked;
            
            if (isEmailValid && isPasswordValid && isTermsChecked) {
                submitButton.classList.add('active');
            } else {
                submitButton.classList.remove('active');
            }
        }
    }
    
    // Add event listeners for form validation
    if (emailInput) {
        emailInput.addEventListener('input', checkFormValidity);
        emailInput.addEventListener('blur', checkFormValidity);
    }
    
    if (passwordInput) {
        passwordInput.addEventListener('input', checkFormValidity);
        passwordInput.addEventListener('blur', checkFormValidity);
    }
    
    if (termsCheckbox) {
        termsCheckbox.addEventListener('change', checkFormValidity);
    }
    
    // Initial check
    checkFormValidity();
});
