<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$title = $fields['title'] ?? 'Join 10,000+ sports fans — free in 30 seconds.';
$subtitle = $fields['subtitle'] ?? 'No credit card required. Your data stays safe with us.';
$button_text = $fields['button_text'] ?? 'Create My Free Account →';

// Social buttons
$show_google = $fields['show_google'] ?? true;
$show_apple = $fields['show_apple'] ?? true;
$google_text = $fields['google_text'] ?? 'Continue with Google';
$apple_text = $fields['apple_text'] ?? 'Continue with Apple';

// Terms link
$terms_link = $fields['terms_link'] ?? null;
$terms_url = $terms_link['url'] ?? '#';
$terms_title = $terms_link['title'] ?? 'Terms & Privacy';
$terms_target = $terms_link['target'] ?? '_blank';

// Form fields
$show_password_toggle = $fields['show_password_toggle'] ?? true;
$email_placeholder = $fields['email_placeholder'] ?? 'Enter your email';
$password_placeholder = $fields['password_placeholder'] ?? 'Create a password';
$email_hint = $fields['email_hint'] ?? 'We\'ll never spam you';
?>
<div class="wp-block-user-signup">
    <div class="signup-container">
        <h2 class="signup-title"><?php echo esc_html($title); ?></h2>
        <p class="signup-subtitle"><?php echo esc_html($subtitle); ?></p>

        <!-- Social Login Buttons -->
        <?php if ($show_google || $show_apple): ?>
        <div class="social-login">
            <?php if ($show_google): ?>
            <button type="button" class="social-btn google-btn">
                <svg class="google-icon" width="20" height="20" viewBox="0 0 24 24">
                    <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                    <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                    <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                    <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                </svg>
                <?php echo esc_html($google_text); ?>
            </button>
            <?php endif; ?>
            
            <?php if ($show_apple): ?>
            <button type="button" class="social-btn apple-btn">
                <svg class="apple-icon" width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M18.71 19.5c-.83 1.24-1.71 2.45-3.05 2.47-1.34.03-1.77-.79-3.29-.79-1.53 0-2 .77-3.27.82-1.31.05-2.3-1.32-3.14-2.53C4.25 17 2.94 12.45 4.7 9.39c.87-1.52 2.43-2.48 4.12-2.51 1.28-.02 2.5.87 3.29.87.78 0 2.26-1.07 3.81-.91.65.03 2.47.26 3.64 1.98-.09.06-2.17 1.28-2.15 3.81.03 3.02 2.65 4.03 2.68 4.04-.03.07-.42 1.44-1.38 2.83M13 3.5c.73-.83 1.94-1.46 2.94-1.5.13 1.17-.34 2.35-1.04 3.19-.69.85-1.83 1.51-2.95 1.42-.15-1.15.41-2.35 1.05-3.11z"/>
                </svg>
                <?php echo esc_html($apple_text); ?>
            </button>
            <?php endif; ?>
        </div>

        <div class="divider">
            <span class="divider-text">or</span>
        </div>
        <?php endif; ?>

        <form class="signup-form" method="post">
            <div class="input-group">
                <input type="email" class="form-input" placeholder="<?php echo esc_attr($email_placeholder); ?>" required>
                <small class="input-hint"><?php echo esc_html($email_hint); ?></small>
            </div>

            <div class="input-group">
                <div class="password-field">
                    <input type="password" class="form-input" placeholder="<?php echo esc_attr($password_placeholder); ?>" required>
                    <?php if ($show_password_toggle): ?>
                    <button type="button" class="toggle-password">
                        <svg class="eye-icon" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M2.5 10C2.5 10 5 5 10 5C15 5 17.5 10 17.5 10C17.5 10 15 15 10 15C5 15 2.5 10 2.5 10Z" stroke="currentColor" stroke-width="1.5"/>
                            <circle cx="10" cy="10" r="2.5" stroke="currentColor" stroke-width="1.5"/>
                        </svg>
                    </button>
                    <?php endif; ?>
                </div>
            </div>

            <div class="terms-group">
                <label class="terms-label">
                    <input type="checkbox" required>
                    <span>I accept <a href="<?php echo esc_url($terms_url); ?>" target="<?php echo esc_attr($terms_target); ?>" class="terms-link"><?php echo esc_html($terms_title); ?></a></span>
                </label>
            </div>

            <button type="submit" class="submit-button">
                <?php echo esc_html($button_text); ?>
            </button>
        </form>

        <div class="signup-footer">
            <div class="footer-item">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock w-4 h-4" aria-hidden="true"><rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg> 
                <span>Secure signup</span>
            </div>
            <div class="footer-item">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-users w-4 h-4" aria-hidden="true"><path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path><path d="M16 3.128a4 4 0 0 1 0 7.744"></path><path d="M22 21v-2a4 4 0 0 0-3-3.87"></path><circle cx="9" cy="7" r="4"></circle></svg> 
                <span>Trusted by 10,000 users</span>
            </div>
        </div>
    </div>
</div>