<?php
/**
 * Betting Results Marquee Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_betting_results',
    'title' => 'Betting Results Marquee',
    'fields' => [
        [
            'key' => 'field_betting_data_repeater',
            'label' => 'Betting Data',
            'name' => 'betting_data',
            'type' => 'repeater',
            'layout' => 'table',
            'required' => 1,
            'min' => 6,
            'button_label' => 'Add Betting Result',
            'sub_fields' => [
                [
                    'key' => 'field_betting_description',
                    'label' => 'Description',
                    'name' => 'description',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., Under 6.5 Rangers/Devils',
                ],
                [
                    'key' => 'field_betting_status',
                    'label' => 'Status',
                    'name' => 'status',
                    'type' => 'radio',
                    'required' => 1,
                    'choices' => [
                        'win' => 'Win',
                        'lose' => 'Lose',
                        'push' => 'Push',
                    ],
                    'default_value' => 'win',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ],
                [
                    'key' => 'field_betting_profit',
                    'label' => 'Profit',
                    'name' => 'profit',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., +$320, -$200, $0',
                    'instructions' => 'Include the + or - sign and $ symbol',
                ],
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/betting-results',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure betting results to display in the scrolling marquee.',
]);
