<?php
/**
 * Pricing Cards Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_pricing_cards',
    'title' => 'Pricing Cards',
    'fields' => [
        [
            'key' => 'field_pricing_cards_repeater',
            'label' => 'Pricing Cards',
            'name' => 'pricing_cards',
            'type' => 'repeater',
            'layout' => 'block',
            'required' => 1,
            'min' => 1,
            'max' => 3,
            'button_label' => 'Add Pricing Card',
            'sub_fields' => [
                [
                    'key' => 'field_most_popular',
                    'label' => 'Most Popular',
                    'name' => 'most_popular',
                    'type' => 'true_false',
                    'required' => 0,
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => 'Yes',
                    'ui_off_text' => 'No',
                ],
                [
                    'key' => 'field_badge_text',
                    'label' => 'Badge Text',
                    'name' => 'badge_text',
                    'type' => 'text',
                    'required' => 1,
                    'default_value' => 'Badge Text',
                    'placeholder' => 'Enter badge text',
                ],
                [
                    'key' => 'field_badge_color',
                    'label' => 'Badge Background Color',
                    'name' => 'badge_color',
                    'type' => 'color_picker',
                    'required' => 0,
                    'default_value' => '#ff6b35',
                    'return_format' => 'string',
                ],
                [
                    'key' => 'field_badge_icon',
                    'label' => 'Badge Icon (SVG Code)',
                    'name' => 'badge_icon',
                    'type' => 'textarea',
                    'required' => 0,
                    'default_value' => '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star h-3 w-3"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>',
                    'placeholder' => 'Pega aquí el código SVG del icono que quieres usar',
                    'rows' => 4,
                ],
                [
                    'key' => 'field_card_background',
                    'label' => 'Card Background Color',
                    'name' => 'card_background',
                    'type' => 'color_picker',
                    'required' => 0,
                    'default_value' => '#ffffff',
                    'return_format' => 'string',
                ],
                [
                    'key' => 'field_card_text_color',
                    'label' => 'Card Text Color',
                    'name' => 'card_text_color',
                    'type' => 'color_picker',
                    'required' => 0,
                    'default_value' => '#1e293b',
                    'return_format' => 'string',
                ],
                [
                    'key' => 'field_card_title',
                    'label' => 'Title',
                    'name' => 'title',
                    'type' => 'text',
                    'required' => 1,
                    'default_value' => 'Plan Name',
                    'placeholder' => 'Enter plan title',
                ],
                [
                    'key' => 'field_card_price',
                    'label' => 'Price',
                    'name' => 'price',
                    'type' => 'number',
                    'required' => 1,
                    'default_value' => 0,
                    'min' => 0,
                    'step' => 0.01,
                    'placeholder' => '0.00',
                ],
                [
                    'key' => 'field_card_price_period',
                    'label' => 'Price Period',
                    'name' => 'price_period',
                    'type' => 'text',
                    'required' => 0,
                    'default_value' => '/month',
                    'placeholder' => '/month, /year, /forever, etc.',
                ],
                [
                    'key' => 'field_card_description',
                    'label' => 'Description',
                    'name' => 'description',
                    'type' => 'text',
                    'required' => 0,
                    'placeholder' => 'Enter plan description',
                ],
                [
                    'key' => 'field_card_list',
                    'label' => 'Features List',
                    'name' => 'list',
                    'type' => 'repeater',
                    'layout' => 'block',
                    'required' => 0,
                    'min' => 0,
                    'button_label' => 'Add Feature',
                    'sub_fields' => [
                        [
                            'key' => 'field_list_option',
                            'label' => 'Feature',
                            'name' => 'list_option',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'Enter feature description',
                        ],
                    ],
                ],
                [
                    'key' => 'field_card_cta',
                    'label' => 'Call to Action',
                    'name' => 'cta',
                    'type' => 'link',
                    'required' => 1,
                    'return_format' => 'array',
                ],
                [
                    'key' => 'field_button_text',
                    'label' => 'Button Text',
                    'name' => 'button_text',
                    'type' => 'text',
                    'required' => 0,
                    'default_value' => 'Get Started',
                    'placeholder' => 'Enter button text',
                ],
                [
                    'key' => 'field_button_color',
                    'label' => 'Button Background Color',
                    'name' => 'button_color',
                    'type' => 'color_picker',
                    'required' => 0,
                    'default_value' => '#0ea5e9',
                    'return_format' => 'string',
                ],
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/pricing-cards',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'layout' => 'vertical',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure up to 3 pricing cards with features and CTAs.',
]);
