<?php
/**
 * Betting Consensus Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_betting_consensus',
    'title' => 'Betting Consensus Configuration',
    'fields' => [
        [
            'key' => 'field_game_title',
            'label' => 'Game Title',
            'name' => 'game_title',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Team A vs Team B Betting Consensus',
            'default_value' => 'Team A vs Team B Betting Consensus',
        ],
        [
            'key' => 'field_subtitle',
            'label' => 'Subtitle',
            'name' => 'subtitle',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., See where the public money is going',
            'default_value' => 'See where the public money is going',
        ],
        [
            'key' => 'field_team1_name',
            'label' => 'Team 1 Name',
            'name' => 'team1_name',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Team A',
            'default_value' => 'Team A',
        ],
        [
            'key' => 'field_team2_name',
            'label' => 'Team 2 Name',
            'name' => 'team2_name',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Team B',
            'default_value' => 'Team B',
        ],
        [
            'key' => 'field_spread_bets',
            'label' => 'Spread Bets',
            'name' => 'spread_bets',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_spread_total_bets',
                    'label' => 'Total Bets',
                    'name' => 'total_bets',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., 12,847',
                    'default_value' => '12,847',
                ],
                [
                    'key' => 'field_team1_spread',
                    'label' => 'Team 1 Spread',
                    'name' => 'team1_spread',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., +3',
                    'default_value' => '+3',
                ],
                [
                    'key' => 'field_team2_spread',
                    'label' => 'Team 2 Spread',
                    'name' => 'team2_spread',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., -3',
                    'default_value' => '-3',
                ],
                [
                    'key' => 'field_major_percentage',
                    'label' => 'Major Percentage',
                    'name' => 'major_percentage',
                    'type' => 'number',
                    'required' => 1,
                    'min' => 0,
                    'max' => 100,
                    'default_value' => 58,
                    'instructions' => 'Enter the percentage of the team with the higher percentage. The minor percentage will be calculated automatically (100 - major).',
                ],
            ],
        ],
        [
            'key' => 'field_total_bets',
            'label' => 'Total Bets',
            'name' => 'total_bets',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_total_bets_count',
                    'label' => 'Total Bets',
                    'name' => 'total_bets',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., 9,234',
                    'default_value' => '9,234',
                ],
                [
                    'key' => 'field_over_line',
                    'label' => 'Over Line',
                    'name' => 'over_line',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., 48.5',
                    'default_value' => '48.5',
                ],
                [
                    'key' => 'field_major_percentage',
                    'label' => 'Major Percentage',
                    'name' => 'major_percentage',
                    'type' => 'number',
                    'required' => 1,
                    'min' => 0,
                    'max' => 100,
                    'default_value' => 65,
                    'instructions' => 'Enter the percentage of the option with the higher percentage (Over or Under). The minor percentage will be calculated automatically (100 - major).',
                ],
            ],
        ],
        [
            'key' => 'field_moneyline_bets',
            'label' => 'Moneyline Bets',
            'name' => 'moneyline_bets',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_moneyline_total_bets',
                    'label' => 'Total Bets',
                    'name' => 'total_bets',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., 7,891',
                    'default_value' => '7,891',
                ],
                [
                    'key' => 'field_team1_moneyline_odds',
                    'label' => 'Team 1 Odds',
                    'name' => 'team1_odds',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., +125',
                    'default_value' => '+125',
                ],
                [
                    'key' => 'field_team2_moneyline_odds',
                    'label' => 'Team 2 Odds',
                    'name' => 'team2_odds',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., -150',
                    'default_value' => '-150',
                ],
                [
                    'key' => 'field_major_percentage',
                    'label' => 'Major Percentage',
                    'name' => 'major_percentage',
                    'type' => 'number',
                    'required' => 1,
                    'min' => 0,
                    'max' => 100,
                    'default_value' => 52,
                    'instructions' => 'Enter the percentage of the team with the higher percentage. The minor percentage will be calculated automatically (100 - major).',
                ],
            ],
        ],
        [
            'key' => 'field_button_link',
            'label' => 'Button Link',
            'name' => 'button_link',
            'type' => 'link',
            'required' => 0,
            'return_format' => 'array',
            'instructions' => 'Set the button text and URL. Leave empty to hide the button.',
        ],
        [
            'key' => 'field_footer_message',
            'label' => 'Footer Message',
            'name' => 'footer_message',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., Updated every 15 minutes with live betting data from major sportsbooks',
            'default_value' => 'Updated every 15 minutes with live betting data from major sportsbooks',
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/betting-consensus',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure the betting consensus widget with public betting percentages.',
]);
