<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$betting_data = $fields['betting_data'] ?? [];
$background_color = $fields['background_color'] ?? '#1a1a1a';
$full_width = $fields['full_width'] ?? true;

$container_class = 'betting-results';
if ($full_width) {
    $container_class .= ' betting-results--full-width';
}
?>

<div class="<?php echo esc_attr($container_class); ?>" style="background-color: <?php echo esc_attr($background_color); ?>;">
    <div class="betting-results__marquee">
        <div class="betting-results__content">
            <?php if (have_rows('betting_data')): ?>
                <?php 
                // First pass - collect all items
                $all_items = [];
                while (have_rows('betting_data')): the_row(); 
                    $description = get_sub_field('description');
                    $status = get_sub_field('status');
                    $profit = get_sub_field('profit');
                    
                    // Determine status class and display
                    $status_class = '';
                    $status_text = '';
                    switch ($status) {
                        case 'win':
                            $status_class = 'betting-results__status--win';
                            $status_text = 'W';
                            break;
                        case 'lose':
                            $status_class = 'betting-results__status--lose';
                            $status_text = 'L';
                            break;
                        case 'push':
                            $status_class = 'betting-results__status--push';
                            $status_text = 'P';
                            break;
                    }
                    
                    $all_items[] = [
                        'status_class' => $status_class,
                        'status_text' => $status_text,
                        'description' => $description,
                        'profit' => $profit
                    ];
                endwhile;
                
                // Render items multiple times for seamless loop
                for ($i = 0; $i < 3; $i++):
                    foreach ($all_items as $index => $item):
                ?>
                    <div class="betting-results__item">
                        <span class="betting-results__description"><?php echo esc_html($item['description']); ?></span>
                        <div class="betting-results__status <?php echo esc_attr($item['status_class']); ?>">
                            <?php echo esc_html($item['status_text']); ?>
                        </div>
                        <span class="betting-results__profit"><?php echo esc_html($item['profit']); ?></span>
                    </div>
                    <div class="betting-results__separator"></div>
                <?php 
                    endforeach;
                endfor;
                ?>
            <?php endif; ?>
        </div>
    </div>
</div>
