<?php
/**
 * Live Odds Block Configuration
 */

function smarter_blocks_live_odds_config() {
    return [
        'name' => 'live-odds',
        'title' => 'Live Odds',
        'description' => 'A live odds comparison table for sports games with multiple sportsbooks and betting types.',
        'category' => 'widgets',
        'icon' => 'chart-bar',
        'keywords' => ['odds', 'betting', 'sports', 'live', 'comparison', 'sportsbook'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'game_title' => 'Falcons vs Commanders Live Odds',
                    'subtitle' => 'Shop around for the best lines and maximize your betting value',
                    'active_tab' => 'spread',
                    'sportsbooks' => [
                        [
                            'name' => 'DraftKings',
                            'spread_team1' => '+3 (-110)',
                            'spread_team2' => '-3 (-110)',
                            'moneyline_team1' => '+140',
                            'moneyline_team2' => '-160',
                            'total_over' => 'O 45.5 (-110)',
                            'total_under' => 'U 45.5 (-110)',
                            'highlighted' => false
                        ],
                        [
                            'name' => 'FanDuel',
                            'spread_team1' => '+3 (-112)',
                            'spread_team2' => '-3 (-108)',
                            'moneyline_team1' => '+135',
                            'moneyline_team2' => '-155',
                            'total_over' => 'O 45.5 (-108)',
                            'total_under' => 'U 45.5 (-112)',
                            'highlighted' => false
                        ],
                        [
                            'name' => 'BetMGM',
                            'spread_team1' => '+3.5 (-115)',
                            'spread_team2' => '-3.5 (-105)',
                            'moneyline_team1' => '+145',
                            'moneyline_team2' => '-165',
                            'total_over' => 'O 45.5 (-105)',
                            'total_under' => 'U 45.5 (-115)',
                            'highlighted' => true
                        ]
                    ],
                    'team1_name' => 'Atlanta Falcons',
                    'team2_name' => 'Washington Commanders',
                    'footer_message' => 'We track best sports odds daily - Join free to get alerts when lines move in your favor'
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
