<?php
/**
 * Newsletter CTA Block Configuration
 */

function smarter_blocks_newsletter_cta_config() {
    return [
        'name' => 'newsletter-cta',
        'title' => 'Newsletter CTA',
        'description' => 'A dark-themed newsletter signup form with email capture, features list, and privacy notice.',
        'category' => 'widgets',
        'icon' => 'email-alt',
        'keywords' => ['newsletter', 'signup', 'email', 'form', 'cta', 'subscribe', 'dark'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'main_headline' => 'Stay Updated - Subscribe to Our Newsletter',
                    'sub_headline' => 'Join thousands of subscribers and get the latest updates delivered to your inbox',
                    'email_placeholder' => 'Enter your email address',
                    'button_text' => 'Subscribe Now',
                    'features' => [
                        [
                            'text' => 'Weekly newsletter with exclusive content'
                        ],
                        [
                            'text' => 'Latest updates and announcements'
                        ],
                        [
                            'text' => 'Special offers and promotions'
                        ]
                    ],
                    'privacy_text' => 'No spam. Unsubscribe anytime. We respect your privacy.'
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
