<?php
/**
 * Sports Analysis CTA Block Configuration
 */

function smarter_blocks_sports_analysis_cta_config() {
    return [
        'name' => 'sports-analysis-cta',
        'title' => 'Sports Analysis CTA',
        'description' => 'A call-to-action block for sports analysis with two configurable versions: signup CTA with button or link CTA with external link.',
        'category' => 'widgets',
        'icon' => 'megaphone',
        'keywords' => ['sports', 'analysis', 'cta', 'call-to-action', 'signup', 'link', 'preview'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'cta_version' => 'signup',
                    'signup_cta' => [
                        'main_text' => 'Like this insight? Get daily previews & picks.',
                        'sub_text' => 'Join thousands of winning bettors with our free sports analysis',
                        'button_text' => 'Sign Up Free',
                        'button_url' => '#',
                    ],
                    'link_cta' => [
                        'main_text' => 'Looking for more sports analysis?',
                        'link_text' => 'See all sports previews here',
                        'link_url' => '#',
                    ],
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
