<?php
/**
 * Sports Analysis CTA Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_sports_analysis_cta',
    'title' => 'Sports Analysis CTA Configuration',
    'fields' => [
        [
            'key' => 'field_cta_version',
            'label' => 'CTA Version',
            'name' => 'cta_version',
            'type' => 'radio',
            'required' => 1,
            'choices' => [
                'signup' => 'Signup CTA (Button Version)',
                'link' => 'Link CTA (Text Link Version)',
            ],
            'default_value' => 'signup',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'instructions' => 'Choose between the signup version with a button or the link version with a text link.',
        ],
        [
            'key' => 'field_signup_cta',
            'label' => 'Signup CTA Settings',
            'name' => 'signup_cta',
            'type' => 'group',
            'layout' => 'block',
            'conditional_logic' => [
                [
                    [
                        'field' => 'field_cta_version',
                        'operator' => '==',
                        'value' => 'signup',
                    ],
                ],
            ],
            'sub_fields' => [
                [
                    'key' => 'field_signup_main_text',
                    'label' => 'Main Text',
                    'name' => 'main_text',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., Like this insight? Get daily previews & picks.',
                    'default_value' => 'Like this insight? Get daily previews & picks.',
                ],
                [
                    'key' => 'field_signup_sub_text',
                    'label' => 'Sub Text',
                    'name' => 'sub_text',
                    'type' => 'text',
                    'required' => 0,
                    'placeholder' => 'e.g., Join thousands of winning bettors with our free sports analysis',
                    'default_value' => 'Join thousands of winning bettors with our free sports analysis',
                ],
                [
                    'key' => 'field_signup_button_link',
                    'label' => 'Button Link',
                    'name' => 'button_link',
                    'type' => 'link',
                    'required' => 1,
                    'return_format' => 'array',
                    'instructions' => 'Set the button text and URL for the signup CTA.',
                ],
            ],
        ],
        [
            'key' => 'field_link_cta',
            'label' => 'Link CTA Settings',
            'name' => 'link_cta',
            'type' => 'group',
            'layout' => 'block',
            'conditional_logic' => [
                [
                    [
                        'field' => 'field_cta_version',
                        'operator' => '==',
                        'value' => 'link',
                    ],
                ],
            ],
            'sub_fields' => [
                [
                    'key' => 'field_link_main_text',
                    'label' => 'Main Text',
                    'name' => 'main_text',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., Looking for more sports analysis?',
                    'default_value' => 'Looking for more sports analysis?',
                ],
                [
                    'key' => 'field_link_link',
                    'label' => 'Link',
                    'name' => 'link',
                    'type' => 'link',
                    'required' => 1,
                    'return_format' => 'array',
                    'instructions' => 'Set the link text and URL. Leave empty to hide the link.',
                ],
            ],
        ],
        [
            'key' => 'field_background_color',
            'label' => 'Background Color',
            'name' => 'background_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#2c3e50',
            'instructions' => 'Choose the background color for the CTA block.',
        ],
        [
            'key' => 'field_text_color',
            'label' => 'Text Color',
            'name' => 'text_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#ffffff',
            'instructions' => 'Choose the text color for the CTA block.',
        ],
        [
            'key' => 'field_link_color',
            'label' => 'Link Color (Link Version)',
            'name' => 'link_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#007bff',
            'instructions' => 'Choose the link color for the link version.',
        ],
        [
            'key' => 'field_envelope_svg',
            'label' => 'Envelope Icon SVG',
            'name' => 'envelope_svg',
            'type' => 'textarea',
            'required' => 0,
            'placeholder' => 'Paste your custom SVG code here...',
            'default_value' => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4 4H20C21.1 4 22 4.9 22 6V18C22 19.1 21.1 20 20 20H4C2.9 20 2 19.1 2 18V6C2 4.9 2.9 4 4 4Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><polyline points="22,6 12,13 2,6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
            'instructions' => 'Customize the envelope icon by pasting your own SVG code. The SVG will inherit the current color from the text. Leave empty to use the default envelope icon.',
            'rows' => 4,
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/sports-analysis-cta',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure the Sports Analysis CTA block with two different versions: signup with button or link with text.',
]);
