<?php
/**
 * Sports Match-up Cards Block Configuration
 */

function smarter_blocks_sports_matchup_cards_config() {
    return [
        'name' => 'sports-matchup-cards',
        'title' => 'Sports Match Up Cards',
        'description' => 'Display multiple sports match-up cards in a horizontal row with team icons, titles, dates, and betting lines.',
        'category' => 'widgets',
        'icon' => 'grid-view',
        'keywords' => ['sports', 'matchup', 'cards', 'betting', 'predictions', 'preview'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'background_color' => '#2a2a2a',
                    'card_background' => '#ffffff',
                    'cards' => [
                        [
                            'team1' => [
                                'name' => 'MIA',
                                'color' => '#0066CC'
                            ],
                            'team2' => [
                                'name' => 'BUF',
                                'color' => '#CC0000'
                            ],
                            'title' => 'Jets vs Dolphins Prediction & Picks',
                            'date_time' => 'Sunday 1:00 PM',
                            'betting_line' => 'BUF -7',
                            'button_text' => 'Read Preview',
                            'button_link' => '#'
                        ],
                        [
                            'team1' => [
                                'name' => 'DAL',
                                'color' => '#0066CC'
                            ],
                            'team2' => [
                                'name' => 'NYG',
                                'color' => '#CC0000'
                            ],
                            'title' => 'Cowboys vs Giants Betting Preview',
                            'date_time' => 'Sunday 4:25 PM',
                            'betting_line' => 'DAL -3.5',
                            'button_text' => 'Read Preview',
                            'button_link' => '#'
                        ]
                    ]
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
