<?php
/**
 * Sports Match-up Cards Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_sports_matchup_cards',
    'title' => 'Sports Match-up Cards Configuration',
    'fields' => [
        [
            'key' => 'field_card_background',
            'label' => 'Card Background',
            'name' => 'card_background',
            'type' => 'color_picker',
            'default_value' => '#ffffff',
            'wrapper' => [
                'width' => '100',
            ],
        ],
        [
            'key' => 'field_team_a_color',
            'label' => 'Team A Color',
            'name' => 'team_a_color',
            'type' => 'color_picker',
            'default_value' => '#0066CC',
            'wrapper' => [
                'width' => '100',
            ],
        ],
        [
            'key' => 'field_team_b_color',
            'label' => 'Team B Color',
            'name' => 'team_b_color',
            'type' => 'color_picker',
            'default_value' => '#CC0000',
            'wrapper' => [
                'width' => '100',
            ],
        ],
        [
            'key' => 'field_cards',
            'label' => 'Match-up Cards',
            'name' => 'cards',
            'type' => 'repeater',
            'layout' => 'block',
            'required' => 1,
            'min' => 1,
            'button_label' => 'Add Match-up Card',
            'collapsed' => 'field_team_a_abbreviation',
            'sub_fields' => [
                [
                    'key' => 'field_team_a_abbreviation',
                    'label' => 'Team A Abbreviation',
                    'name' => 'team_a_abbreviation',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., MIA',
                    'maxlength' => 3,
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_team_b_abbreviation',
                    'label' => 'Team B Abbreviation',
                    'name' => 'team_b_abbreviation',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., BUF',
                    'maxlength' => 3,
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_matchup_description',
                    'label' => 'Matchup Description',
                    'name' => 'matchup_description',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., Jets vs Dolphins Prediction & Picks',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_date_and_hour',
                    'label' => 'Date and Hour',
                    'name' => 'date_and_hour',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., Sunday 1:00 PM',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_betting_line',
                    'label' => 'Betting Line',
                    'name' => 'betting_line',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., BUF -7',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_footer_link',
                    'label' => 'Footer Link',
                    'name' => 'footer_link',
                    'type' => 'link',
                    'return_format' => 'array',
                    'required' => 1,
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/sports-matchup-cards',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure multiple sports match-up cards with team icons, titles, dates, and betting lines.',
]);