<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$card_background = $fields['card_background'] ?? '#ffffff';
$team_a_color = $fields['team_a_color'] ?? '#0066CC';
$team_b_color = $fields['team_b_color'] ?? '#CC0000';
$cards = $fields['cards'] ?? [];

// Set CSS custom properties
$css_vars = [
    '--sports-cards-card-bg' => $card_background,
    '--sports-cards-team-a-color' => $team_a_color,
    '--sports-cards-team-b-color' => $team_b_color,
];
$css_vars_string = '';
foreach ($css_vars as $property => $value) {
    $css_vars_string .= $property . ': ' . esc_attr($value) . '; ';
}
?>

<div class="sports-matchup-cards" style="<?php echo $css_vars_string; ?>">
    <?php if (!empty($cards)): ?>
        <?php 
        $card_count = count($cards);
        $container_class = 'sports-matchup-cards__container';
        if ($card_count === 1) {
            $container_class .= ' sports-matchup-cards__container--single';
        } elseif ($card_count === 2) {
            $container_class .= ' sports-matchup-cards__container--double';
        } elseif ($card_count === 3) {
            $container_class .= ' sports-matchup-cards__container--triple';
        }
        ?>
        <div class="<?php echo esc_attr($container_class); ?>">
            <?php foreach ($cards as $index => $card): ?>
                <div class="sports-matchup-cards__card">
                    <!-- Team Icons and VS -->
                    <div class="sports-matchup-cards__header">
                        <div class="sports-matchup-cards__team-icon sports-matchup-cards__team-icon--team-a">
                            <?php echo esc_html($card['team_a_abbreviation'] ?? ''); ?>
                        </div>
                        <div class="sports-matchup-cards__vs">VS</div>
                        <div class="sports-matchup-cards__team-icon sports-matchup-cards__team-icon--team-b">
                            <?php echo esc_html($card['team_b_abbreviation'] ?? ''); ?>
                        </div>
                    </div>

                    <!-- Match-up Details -->
                    <div class="sports-matchup-cards__content">
                        <h3 class="sports-matchup-cards__title">
                            <?php echo esc_html($card['matchup_description'] ?? ''); ?>
                        </h3>
                        <div class="sports-matchup-cards__date-time">
                            <?php echo esc_html($card['date_and_hour'] ?? ''); ?>
                        </div>
                        <div class="sports-matchup-cards__betting-line">
                            <?php echo esc_html($card['betting_line'] ?? ''); ?>
                        </div>
                    </div>

                    <!-- Separator -->
                    <div class="sports-matchup-cards__separator"></div>

                    <!-- Footer Link -->
                    <?php if (!empty($card['footer_link']) && !empty($card['footer_link']['url'])): ?>
                        <div class="sports-matchup-cards__footer">
                            <a href="<?php echo esc_url($card['footer_link']['url']); ?>" 
                               target="<?php echo esc_attr($card['footer_link']['target'] ?? '_self'); ?>" 
                               class="sports-matchup-cards__button">
                                <?php echo esc_html($card['footer_link']['title'] ?? 'Read Preview'); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>
