<?php
/**
 * Sports Match-up Block Configuration
 */

function smarter_blocks_sports_matchup_config() {
    return [
        'name' => 'sports-matchup',
        'title' => 'Sports Match Up',
        'description' => 'Display a sports match-up between two teams with records, team colors, and betting odds.',
        'category' => 'widgets',
        'icon' => 'sports',
        'keywords' => ['sports', 'matchup', 'teams', 'betting', 'odds', 'records'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'card_background' => '#ffffff',
                    'team1' => [
                        'name' => 'Atlanta Falcons',
                        'abbreviation' => 'ATL',
                        'color' => '#E50000',
                        'record' => '2-1 (1-2 ATS)'
                    ],
                    'team2' => [
                        'name' => 'Washington Commanders',
                        'abbreviation' => 'WAS',
                        'color' => '#A07828',
                        'record' => '2-1 (2-1 ATS)'
                    ],
                    'betting_odds' => [
                        'spread' => 'WAS -3',
                        'over_under' => '48.5'
                    ]
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
