<?php
/**
 * Sports Prediction Analysis Block Configuration
 */

function smarter_blocks_sports_prediction_analysis_config() {
    return [
        'name' => 'sports-prediction-analysis',
        'title' => 'Sports Prediction Analysis',
        'description' => 'A comprehensive sports prediction analysis block with expert predictions, confidence levels, and betting insights.',
        'category' => 'widgets',
        'icon' => 'chart-area',
        'keywords' => ['sports', 'prediction', 'analysis', 'betting', 'expert', 'confidence', 'value'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'title' => 'The Lean - Team A vs Team B Prediction',
                    'analysis_text' => 'While Team A has the offensive firepower to keep pace, Team B\'s home field advantage and superior defensive metrics give them the edge. Team B has covered in 7 of their last 10 games as home favorites, showing strong value in this matchup.',
                    'expert_prediction' => 'Team B -3 and UNDER 48.5',
                    'confidence_level' => '7/10',
                    'expected_value' => '+12%',
                    'cta_text' => 'Want more sports predictions?',
                    'cta_link_text' => 'See all sports previews here',
                    'cta_link_url' => '#',
                    'disclaimer' => '*This is analysis only. Always bet responsibly and within your means. Must be 21+.'
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
