<?php
/**
 * Sports Prediction Analysis Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_sports_prediction_analysis',
    'title' => 'Sports Prediction Analysis Configuration',
    'fields' => [
        [
            'key' => 'field_title',
            'label' => 'Title',
            'name' => 'title',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., The Lean - Team A vs Team B Prediction',
            'default_value' => 'The Lean - Team A vs Team B Prediction',
        ],
        [
            'key' => 'field_analysis_text',
            'label' => 'Analysis Text',
            'name' => 'analysis_text',
            'type' => 'textarea',
            'required' => 1,
            'rows' => 4,
            'placeholder' => 'Enter your detailed analysis of the game...',
            'default_value' => 'While Team A has the offensive firepower to keep pace, Team B\'s home field advantage and superior defensive metrics give them the edge. Team B has covered in 7 of their last 10 games as home favorites, showing strong value in this matchup.',
        ],
        [
            'key' => 'field_expert_prediction',
            'label' => 'Expert Prediction',
            'name' => 'expert_prediction',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Team B -3 and UNDER 48.5',
            'default_value' => 'Team B -3 and UNDER 48.5',
            'instructions' => 'The main prediction text that will be prominently displayed.',
        ],
        [
            'key' => 'field_confidence_level',
            'label' => 'Confidence Level',
            'name' => 'confidence_level',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., 7/10',
            'default_value' => '7/10',
            'instructions' => 'Confidence level in the prediction (e.g., 7/10, 85%, High).',
        ],
        [
            'key' => 'field_expected_value',
            'label' => 'Expected Value',
            'name' => 'expected_value',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., +12%',
            'default_value' => '+12%',
            'instructions' => 'Expected value or edge percentage (optional).',
        ],
        [
            'key' => 'field_cta_text',
            'label' => 'CTA Text',
            'name' => 'cta_text',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., Want more sports predictions? See all sports previews here',
            'default_value' => 'Want more sports predictions? See all sports previews here',
            'instructions' => 'Text that appears before the CTA link (optional).',
        ],
        [
            'key' => 'field_cta_link',
            'label' => 'CTA Link',
            'name' => 'cta_link',
            'type' => 'link',
            'required' => 0,
            'return_format' => 'array',
            'instructions' => 'Link for the call-to-action section (optional).',
        ],
        [
            'key' => 'field_disclaimer',
            'label' => 'Disclaimer',
            'name' => 'disclaimer',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., *This is analysis only. Always bet responsibly and within your means. Must be 21+.',
            'default_value' => '*This is analysis only. Always bet responsibly and within your means. Must be 21+.',
            'instructions' => 'Responsible gambling disclaimer (optional).',
        ],
        [
            'key' => 'field_prediction_background_color',
            'label' => 'Prediction Background Color',
            'name' => 'prediction_background_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#1a1a1a',
            'instructions' => 'Background color for the expert prediction section.',
        ],
        [
            'key' => 'field_prediction_text_color',
            'label' => 'Prediction Text Color',
            'name' => 'prediction_text_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#ffffff',
            'instructions' => 'Text color for the expert prediction section.',
        ],
        [
            'key' => 'field_show_icon',
            'label' => 'Show Expert Prediction Icon',
            'name' => 'show_icon',
            'type' => 'true_false',
            'required' => 0,
            'default_value' => 1,
            'ui' => 1,
            'instructions' => 'Show or hide the icon in the "Our Expert Prediction" section.',
        ],
        [
            'key' => 'field_custom_icon_svg',
            'label' => 'Custom Icon SVG',
            'name' => 'custom_icon_svg',
            'type' => 'textarea',
            'required' => 0,
            'rows' => 4,
            'placeholder' => 'Paste your custom SVG code here...',
            'instructions' => 'Custom SVG code for the expert prediction icon. Leave empty to use default icon.',
        ],
        [
            'key' => 'field_icon_color',
            'label' => 'Icon Color',
            'name' => 'icon_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#ff6b6b',
            'instructions' => 'Color for the target/bullseye icon.',
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/sports-prediction-analysis',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure the Sports Prediction Analysis block with expert predictions and betting insights.',
]);
