<?php
/**
 * Testimonials Block Template
 * 
 * Available variables:
 * $fields - ACF fields array
 * $is_preview - Whether this is a preview
 * $post_id - Current post ID
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$title = $fields['title'] ?? 'What Our Customers Say';
$subtitle = $fields['subtitle'] ?? '';
$background_color = $fields['background_color'] ?? '#f8f9fa';
$layout = $fields['layout'] ?? 'grid';
$testimonials = $fields['testimonials'] ?? [];

// Don't render if no testimonials
if (empty($testimonials)) {
    return;
}
?>

<div class="testimonials-section" style="background-color: <?php echo esc_attr($background_color); ?>;">
    <div class="testimonials-section__container">
        <div class="testimonials-section__header">
            <p class="testimonials-section__title"><?php echo esc_html($title); ?></p>
            
            <?php if (!empty($subtitle)) : ?>
                <div class="testimonials-section__subtitle"><?php echo wp_kses_post($subtitle); ?></div>
            <?php endif; ?>
        </div>
        
        <div class="testimonials-section__content testimonials-section__content--<?php echo esc_attr($layout); ?>">
            <?php foreach ($testimonials as $testimonial) : ?>
                <div class="testimonial-item">
                    <div class="testimonial-item__content">
                        <div class="testimonial-item__quote">
                            "<?php echo esc_html($testimonial['content']); ?>"
                        </div>
                        
                        <?php if (!empty($testimonial['rating'])) : ?>
                            <div class="testimonial-item__rating">
                                <?php for ($i = 1; $i <= 5; $i++) : ?>
                                    <span class="star <?php echo $i <= $testimonial['rating'] ? 'star--filled' : 'star--empty'; ?>">★</span>
                                <?php endfor; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="testimonial-item__author">
                        <?php if (!empty($testimonial['avatar']['url'])) : ?>
                            <div class="testimonial-item__avatar">
                                <img src="<?php echo esc_url($testimonial['avatar']['url']); ?>" 
                                     alt="<?php echo esc_attr($testimonial['name']); ?>"
                                     width="60" height="60">
                            </div>
                        <?php endif; ?>
                        
                        <div class="testimonial-item__info">
                            <div class="testimonial-item__name"><?php echo esc_html($testimonial['name']); ?></div>
                            <?php if (!empty($testimonial['position'])) : ?>
                                <div class="testimonial-item__position"><?php echo esc_html($testimonial['position']); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
