<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$game_title = $fields['game_title'] ?? 'Team A vs Team B Betting Consensus';
$subtitle = $fields['subtitle'] ?? 'See where the public money is going';
$team1_name = $fields['team1_name'] ?? 'Team A';
$team2_name = $fields['team2_name'] ?? 'Team B';
$spread_bets = $fields['spread_bets'] ?? [];
$total_bets = $fields['total_bets'] ?? [];
$moneyline_bets = $fields['moneyline_bets'] ?? [];
$button_link = $fields['button_link'] ?? [];
$button_text = $button_link['title'] ?? 'Get Consensus Reports Free';
$button_url = $button_link['url'] ?? '#';
$button_target = $button_link['target'] ?? '_self';
$footer_message = $fields['footer_message'] ?? 'Updated every 15 minutes with live betting data from major sportsbooks';
?>

<div class="betting-consensus">
    <!-- Header Section -->
    <div class="betting-consensus__header">
        <div class="betting-consensus__header-content">
            <div class="betting-consensus__title">
                <div class="betting-consensus__icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
                        <path d="M38.7982 39.3279H21.9749C21.3112 39.3279 20.7731 38.8558 20.7731 38.2734V29.2902C20.7731 25.7512 23.1895 22.6048 26.9291 21.2742C27.4848 21.0765 28.1216 21.2684 28.4214 21.7242L30.3865 24.7105L32.3516 21.7242C32.6514 21.2686 33.2881 21.0765 33.844 21.2742C37.5837 22.6047 40 25.7512 40 29.2902V38.2734C40 38.8558 39.462 39.3279 38.7982 39.3279ZM23.1767 37.219H37.5962V29.2902C37.5962 26.9216 36.1643 24.7853 33.8742 23.628L31.4271 27.3468C31.2125 27.673 30.8158 27.874 30.3864 27.874C29.957 27.874 29.5603 27.673 29.3457 27.3468L26.8987 23.628C24.6086 24.7854 23.1766 26.9215 23.1766 29.2902V37.219H23.1767Z" fill="#0FABBD"/>
                        <path d="M30.3865 18.5122C26.7914 18.5122 23.6805 16.3749 22.8212 13.3147C22.6625 12.7493 23.0562 12.1779 23.7006 12.0385C24.345 11.8993 24.9961 12.2447 25.155 12.8102C25.7491 14.9256 27.9003 16.4031 30.3866 16.4031C33.3581 16.4031 35.7756 14.282 35.7756 11.6747C35.7756 9.06743 33.3581 6.94635 30.3866 6.94635C29.3591 6.94635 28.3587 7.20236 27.4938 7.68658C26.9344 7.9999 26.1914 7.8558 25.8342 7.3649C25.4771 6.87407 25.6414 6.22209 26.2008 5.90877C27.4526 5.20794 28.9001 4.8374 30.3865 4.8374C34.6833 4.8374 38.1791 7.90465 38.1791 11.6747C38.1791 15.4448 34.6833 18.5122 30.3865 18.5122Z" fill="#0FABBD"/>
                        <path d="M11.6132 16.4238C6.45251 16.4238 2.25403 12.74 2.25403 8.21196C2.25403 3.6839 6.45251 0 11.6132 0C16.7739 0 20.9723 3.6839 20.9723 8.21196C20.9723 12.74 16.7739 16.4238 11.6132 16.4238ZM11.6132 2.10895C7.77792 2.10895 4.6577 4.84683 4.6577 8.21196C4.6577 11.5771 7.77792 14.3148 11.6132 14.3148C15.4485 14.3148 18.5687 11.5771 18.5687 8.21196C18.5687 4.84683 15.4485 2.10895 11.6132 2.10895Z" fill="#0FABBD"/>
                        <path d="M22.024 39.3278H1.20179C0.538041 39.3278 0 38.8557 0 38.2734V27.1548C0 22.8771 2.92071 19.0739 7.44083 17.4656C7.99655 17.2682 8.63334 17.4598 8.93318 17.9157L11.6127 21.9879L14.2922 17.9157C14.592 17.4601 15.2286 17.2678 15.7847 17.4656C20.3049 19.0739 23.2256 22.877 23.2256 27.1548V38.2734C23.2257 38.8557 22.6877 39.3278 22.024 39.3278ZM2.40359 37.2189H20.822V27.1548C20.822 24.0469 18.8907 21.2527 15.8227 19.8078L12.6535 24.6241C12.4388 24.9503 12.0422 25.1514 11.6128 25.1514C11.1834 25.1514 10.7866 24.9503 10.572 24.6241L7.40274 19.8078C4.33488 21.2528 2.4035 24.0469 2.4035 27.1548L2.40359 37.2189Z" fill="#0FABBD"/>
                    </svg>
                </div>
                <p class="betting-consensus__game-title"><?php echo esc_html($game_title); ?></p>
            </div>
            
            <?php if ($subtitle): ?>
                <p class="betting-consensus__subtitle"><?php echo esc_html($subtitle); ?></p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Betting Sections -->
    <div class="betting-consensus__content">
        <!-- Spread Bets Section -->
        <?php if (!empty($spread_bets)): ?>
            <div class="betting-consensus__section">
                <div class="betting-consensus__section-header">
                    <p class="betting-consensus__section-title">Spread Bets</p>
                    <p class="betting-consensus__total-bets"><?php echo esc_html($spread_bets['total_bets'] ?? '0'); ?> total bets</p>
                </div>
                <?php
                $major_percentage = intval($spread_bets['major_percentage'] ?? 58);
                $minor_percentage = 100 - $major_percentage;
                $team1_percentage = $major_percentage;
                $team2_percentage = $minor_percentage;
                ?>
                <div class="betting-consensus__options">
                    <div class="betting-consensus__option">
                        <div class="betting-consensus__option-header">
                            <span class="betting-consensus__option-label"><?php echo esc_html($team1_name . ' ' . ($spread_bets['team1_spread'] ?? '')); ?></span>
                            <span class="betting-consensus__option-percentage"><?php echo esc_html($team1_percentage); ?>%</span>
                        </div>
                        <div class="betting-consensus__progress-bar">
                            <div class="betting-consensus__progress-fill" style="width: <?php echo esc_attr($major_percentage); ?>%"></div>
                        </div>
                        <div class="betting-consensus__option-header">
                            <span class="betting-consensus__option-label"><?php echo esc_html($team2_name . ' ' . ($spread_bets['team2_spread'] ?? '')); ?></span>
                            <span class="betting-consensus__option-percentage"><?php echo esc_html($team2_percentage); ?>%</span>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Total Bets Section -->
        <?php if (!empty($total_bets)): ?>
            <div class="betting-consensus__section">
                <div class="betting-consensus__section-header">
                    <p class="betting-consensus__section-title">Total Bets</p>
                    <p class="betting-consensus__total-bets"><?php echo esc_html($total_bets['total_bets'] ?? '0'); ?> total bets</p>
                </div>
                
                <?php 
                $major_percentage = intval($total_bets['major_percentage'] ?? 65);
                $minor_percentage = 100 - $major_percentage;
                $over_percentage = $major_percentage;
                $under_percentage = $minor_percentage;
                ?>
                <div class="betting-consensus__options">
                    <div class="betting-consensus__option">
                        <div class="betting-consensus__option-header">
                            <span class="betting-consensus__option-label">Over <?php echo esc_html($total_bets['over_line'] ?? ''); ?></span>
                            <span class="betting-consensus__option-percentage"><?php echo esc_html($over_percentage); ?>%</span>
                        </div>
                        <div class="betting-consensus__progress-bar">
                            <div class="betting-consensus__progress-fill" style="width: <?php echo esc_attr($major_percentage); ?>%"></div>
                        </div>
                        <div class="betting-consensus__option-header">
                            <span class="betting-consensus__option-label">Under <?php echo esc_html($total_bets['over_line'] ?? ''); ?></span>
                            <span class="betting-consensus__option-percentage"><?php echo esc_html($under_percentage); ?>%</span>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Moneyline Bets Section -->
        <?php if (!empty($moneyline_bets)): ?>
            <div class="betting-consensus__section">
                <div class="betting-consensus__section-header">
                    <p class="betting-consensus__section-title">Moneyline Bets</p>
                    <p class="betting-consensus__total-bets"><?php echo esc_html($moneyline_bets['total_bets'] ?? '0'); ?> total bets</p>
                </div>
                
                <?php 
                $major_percentage = intval($moneyline_bets['major_percentage'] ?? 52);
                $minor_percentage = 100 - $major_percentage;
                $team1_percentage = $major_percentage;
                $team2_percentage = $minor_percentage;
                ?>
                <div class="betting-consensus__options">
                    <div class="betting-consensus__option">
                        <div class="betting-consensus__option-header">
                            <span class="betting-consensus__option-label"><?php echo esc_html($team1_name . ' (' . ($moneyline_bets['team1_odds'] ?? '') . ')'); ?></span>
                            <span class="betting-consensus__option-percentage"><?php echo esc_html($team1_percentage); ?>%</span>
                        </div>
                        <div class="betting-consensus__progress-bar">
                            <div class="betting-consensus__progress-fill" style="width: <?php echo esc_attr($major_percentage); ?>%"></div>
                        </div>
                        <div class="betting-consensus__option-header">
                            <span class="betting-consensus__option-label"><?php echo esc_html($team2_name . ' (' . ($moneyline_bets['team2_odds'] ?? '') . ')'); ?></span>
                            <span class="betting-consensus__option-percentage"><?php echo esc_html($team2_percentage); ?>%</span>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Action Button -->
    <?php if (!empty($button_link) && !empty($button_text)): ?>
        <div class="betting-consensus__action">
            <a href="<?php echo esc_url($button_url); ?>" target="<?php echo esc_attr($button_target); ?>" class="betting-consensus__button">
                <?php echo esc_html($button_text); ?>
            </a>
        </div>
    <?php endif; ?>

    <!-- Footer Section -->
    <?php if ($footer_message): ?>
        <div class="betting-consensus__footer">
            <p class="betting-consensus__footer-text"><?php echo esc_html($footer_message); ?></p>
        </div>
    <?php endif; ?>
</div>
