<?php
/**
 * Hero Template Block Configuration
 */

function smarter_blocks_hero_template_config() {
    return [
        'name' => 'hero-template',
        'title' => 'Hero Template',
        'description' => 'A betting platform hero section with left content area and right picks sidebar.',
        'category' => 'formatting',
        'icon' => 'align-wide',
        'keywords' => ['hero', 'template', 'betting', 'picks', 'landing'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'left_section' => [
                        'badge_text' => '#1 Rated Betting Platform',
                        'headline' => 'Smarter Betting Starts Here',
                        'description' => 'Get verified sports picks from expert handicappers with proven track records.',
                        'email_placeholder' => 'Enter your email',
                        'button_text' => 'Get Today\'s Free Pick',
                        'disclaimer' => 'No spam. Unsubscribe anytime. See our verified results first.',
                        'stats' => [
                            ['value' => '68%', 'label' => 'Win Rate'],
                            ['value' => '+$12.4K', 'label' => 'Avg. Profit'],
                            ['value' => '10K+', 'label' => 'Members']
                        ]
                    ],
                    'right_section' => [
                        'title' => 'Today\'s Hot Picks',
                        'live_indicator' => true,
                        'picks' => [
                            [
                                'teams' => 'Lakers vs Warriors',
                                'league' => 'NBA',
                                'time' => '8:00 PM ET',
                                'pick' => 'Lakers +4.5',
                                'confidence' => '92%'
                            ]
                        ],
                        'roi_value' => '+24.7%',
                        'roi_period' => 'Last 30 days',
                        'streak_value' => '7W',
                        'streak_period' => 'Current run'
                    ]
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
