<?php
/**
 * Hero Template Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_hero_template',
    'title' => 'Hero Template',
    'fields' => [
        [
            'key' => 'field_hero_template_left_section',
            'label' => 'Left Section (Main Content)',
            'name' => 'left_section',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_hero_template_badge_text',
                    'label' => 'Badge Text',
                    'name' => 'badge_text',
                    'type' => 'text',
                    'default_value' => '#1 Rated Betting Platform',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_headline',
                    'label' => 'Headline',
                    'name' => 'headline',
                    'type' => 'text',
                    'default_value' => 'Smarter Betting Starts Here',
                    'required' => 1,
                ],
                [
                    'key' => 'field_hero_template_description',
                    'label' => 'Description',
                    'name' => 'description',
                    'type' => 'textarea',
                    'default_value' => 'Get verified sports picks from expert handicappers with proven track records. Data-driven analysis meets professional insights.',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_email_placeholder',
                    'label' => 'Email Input Placeholder',
                    'name' => 'email_placeholder',
                    'type' => 'text',
                    'default_value' => 'Enter your email',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_button_text',
                    'label' => 'Button Text',
                    'name' => 'button_text',
                    'type' => 'text',
                    'default_value' => 'Get Today\'s Free Pick',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_disclaimer',
                    'label' => 'Disclaimer Text',
                    'name' => 'disclaimer',
                    'type' => 'text',
                    'default_value' => 'No spam. Unsubscribe anytime. See our verified results first.',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_stats',
                    'label' => 'Statistics',
                    'name' => 'stats',
                    'type' => 'repeater',
                    'layout' => 'table',
                    'button_label' => 'Add Statistic',
                    'sub_fields' => [
                        [
                            'key' => 'field_hero_template_stat_value',
                            'label' => 'Value',
                            'name' => 'value',
                            'type' => 'text',
                            'required' => 1,
                        ],
                        [
                            'key' => 'field_hero_template_stat_label',
                            'label' => 'Label',
                            'name' => 'label',
                            'type' => 'text',
                            'required' => 1,
                        ],
                    ],
                ],
            ],
        ],
        [
            'key' => 'field_hero_template_right_section',
            'label' => 'Right Section (Picks & Stats)',
            'name' => 'right_section',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_hero_template_picks_title',
                    'label' => 'Picks Section Title',
                    'name' => 'title',
                    'type' => 'text',
                    'default_value' => 'Today\'s Hot Picks',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_live_indicator',
                    'label' => 'Show Live Indicator',
                    'name' => 'live_indicator',
                    'type' => 'true_false',
                    'default_value' => 1,
                    'ui' => 1,
                ],
                [
                    'key' => 'field_hero_template_picks',
                    'label' => 'Sports Picks',
                    'name' => 'picks',
                    'type' => 'repeater',
                    'layout' => 'block',
                    'button_label' => 'Add Pick',
                    'sub_fields' => [
                        [
                            'key' => 'field_hero_template_pick_teams',
                            'label' => 'Teams/Match',
                            'name' => 'teams',
                            'type' => 'text',
                            'required' => 1,
                        ],
                        [
                            'key' => 'field_hero_template_pick_league',
                            'label' => 'League',
                            'name' => 'league',
                            'type' => 'text',
                            'required' => 1,
                        ],
                        [
                            'key' => 'field_hero_template_pick_time',
                            'label' => 'Time',
                            'name' => 'time',
                            'type' => 'text',
                            'required' => 1,
                        ],
                        [
                            'key' => 'field_hero_template_pick_selection',
                            'label' => 'Pick Selection',
                            'name' => 'pick',
                            'type' => 'text',
                            'required' => 1,
                        ],
                        [
                            'key' => 'field_hero_template_pick_confidence',
                            'label' => 'Confidence %',
                            'name' => 'confidence',
                            'type' => 'text',
                            'required' => 1,
                        ],
                    ],
                ],
                [
                    'key' => 'field_hero_template_view_all_text',
                    'label' => 'View All Button Text',
                    'name' => 'view_all_text',
                    'type' => 'text',
                    'default_value' => 'View All Picks',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_roi_value',
                    'label' => 'ROI Value',
                    'name' => 'roi_value',
                    'type' => 'text',
                    'default_value' => '+24.7%',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_roi_period',
                    'label' => 'ROI Period',
                    'name' => 'roi_period',
                    'type' => 'text',
                    'default_value' => 'Last 30 days',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_streak_value',
                    'label' => 'Streak Value',
                    'name' => 'streak_value',
                    'type' => 'text',
                    'default_value' => '7W',
                    'required' => 0,
                ],
                [
                    'key' => 'field_hero_template_streak_period',
                    'label' => 'Streak Period',
                    'name' => 'streak_period',
                    'type' => 'text',
                    'default_value' => 'Current run',
                    'required' => 0,
                ],
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/hero-template',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
]);
