# RDG Corp / Smarter Blocks Plugin for WordPress

Tags: rdg corp, smarter blocks, rdg, corp
Requires at least: 6.0
Tested up to: 6.0
Requires PHP: 8.3
Stable tag: 1.1.2
License: GPLv3 or later
License URI: http://www.gnu.org/licenses/gpl-3.0.html

## Requirements

- WordPress 6.0 or higher
- PHP 8.3 or higher
- Advanced Custom Fields Pro (recommended)

# Changelog

## 1.1.2
- Added Bookie Promo block - promotional card for betting/gaming platforms
- Bookie Promo includes logo image field, promotional text sections, 1-5 star rating system, and dual CTA buttons with link fields
- Added Mobile Newsletter Banner block - sticky mobile-only banner for newsletter signup
- Mobile Newsletter Banner features primary/secondary text, CTA link field, customizable colors, and close button functionality
- Mobile Newsletter Banner is sticky positioned at bottom of screen and only visible on mobile devices (max-width: 768px)
- Both blocks support customizable colors and responsive design

## 1.1.1
- Delete overflow hidden.

## 1.1.0
- Fixed Sports Stats Display block player injury fields structure
- Changed player injury from separate 'name' and 'status' fields to single 'player_info' field
- Removed footer SVG icons from all cards while keeping card header icons
- Updated Sports Stats Display template to use new player_info field structure
- Enhanced Sports Matchup Cards block with customizable team colors
- Added Team A and Team B color picker fields for personalized team branding
- Improved card layout with better typography and spacing
- Added letter-spacing and text-balance for better readability
- Updated responsive design with improved mobile padding
- Enhanced button styling with full-width design
- Fixed grid layout for better card distribution
- Improved visual hierarchy with centered content alignment
- Created missing Sports Analysis Cards block with complete file structure
- Added config.php, template.php, fields.php, and style.css for Sports Analysis Cards
- Fixed Sports Matchup block team name display issue
- Updated Sports Matchup template to use correct field structure (team1_name, team2_name)
- Enhanced Sports Matchup Cards with 4-column grid layout and 32px gap
- Added responsive grid behavior for different card counts (1-4+ cards)
- Implemented dynamic centering for single, double, and triple card layouts

## 1.0.12
- Create a new tag for solve a bug with tag on wp

## 1.0.11
- Changes on descriptions for inputs

## 1.0.10
- Added settings for edit color of texts
- Added subtitle input and SVG input for list features icon
- Added settings for solid and gradient color on button and badge
- Organized of the settings in groups

## 1.0.9
- Dynamic editing of texts and colors is added
- Added input for dynamic SVG

## 1.0.8
- Added recaptcha.
- Added custom tag scripts.
- Captcha works fine

## 1.0.7
- Added Settings Page for User Signup Block
- Configurable form action URL and method
- Social login configuration (Google & Apple)
- Email notification settings
- Redirect URL configuration
- Success/Error message customization

#### Social Login Setup:

For Google Sign-In:
1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Create a new project or select existing one
3. Enable Google+ API
4. Create OAuth 2.0 credentials
5. Add your domain to authorized origins
6. Copy the Client ID to the settings page

For Apple Sign-In:
1. Go to [Apple Developer Console](https://developer.apple.com/)
2. Create a new App ID
3. Enable Sign In with Apple capability
4. Create a Service ID
5. Configure the Service ID with your domain
6. Copy the Service ID to the settings page

## 1.0.6
- Block User Sign Up added.

## 1.0.5
- Hero Template added.
- Pricing Cards added.
- Betting Results added.
- Plugin now supports global css.

## 1.0.4
- Added inline blocks

