<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values with defaults
$left_section = $fields['left_section'] ?? [];
$right_section = $fields['right_section'] ?? [];

// Left section data
$badge_text = $left_section['badge_text'] ?? '#1 Rated Betting Platform';
$headline = $left_section['headline'] ?? 'Smarter Betting Starts Here';
$description = $left_section['description'] ?? 'Get verified sports picks from expert handicappers with proven track records. Data-driven analysis meets professional insights.';
$email_placeholder = $left_section['email_placeholder'] ?? 'Enter your email';
$button_text = $left_section['button_text'] ?? 'Get Today\'s Free Pick';
$disclaimer = $left_section['disclaimer'] ?? 'No spam. Unsubscribe anytime. See our verified results first.';
$stats = $left_section['stats'] ?? [];

// Right section data
$picks_title = $right_section['title'] ?? 'Today\'s Hot Picks';
$live_indicator = $right_section['live_indicator'] ?? true;
$picks = $right_section['picks'] ?? [];
$view_all_text = $right_section['view_all_text'] ?? 'View All Picks';
$roi_value = $right_section['roi_value'] ?? '+24.7%';
$roi_period = $right_section['roi_period'] ?? 'Last 30 days';
$streak_value = $right_section['streak_value'] ?? '7W';
$streak_period = $right_section['streak_period'] ?? 'Current run';
?>

<div class="hero-template">
    <!-- Background Gradients -->
    <div class="hero-template__gradient hero-template__gradient--1"></div>
    <div class="hero-template__gradient hero-template__gradient--2"></div>
    
    <div class="hero-template__container">
        <!-- Left Section - Main Content -->
        <div class="hero-template__left">
            <!-- Badge -->
            <?php if ($badge_text): ?>
                <div class="hero-template__badge">
                    <span class="hero-template__badge-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star h-4 w-4 text-accent"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>
                    </span>
                    <?php echo esc_html($badge_text); ?>
                </div>
            <?php endif; ?>

            <!-- Headline -->
            <h1 class="hero-template__headline">
                <?php 
                $headline_parts = explode(' ', $headline);
                $first_part = array_slice($headline_parts, 0, 2);
                $second_part = array_slice($headline_parts, 2);
                ?>
                <span class="hero-template__headline--white"><?php echo esc_html(implode(' ', $first_part)); ?></span>
                <?php if (!empty($second_part)): ?>
                    <span class="hero-template__headline--green"><?php echo esc_html(implode(' ', $second_part)); ?></span>
                <?php endif; ?>
            </h1>

            <!-- Description -->
            <p class="hero-template__description">
                <?php echo esc_html($description); ?>
            </p>

            <!-- Email Form -->
            <div class="hero-template__form">
                <input type="email" 
                       class="hero-template__email-input" 
                       placeholder="<?php echo esc_attr($email_placeholder); ?>">
                <button class="hero-template__cta-button">
                    <?php echo esc_html($button_text); ?>
                </button>
            </div>

            <!-- Disclaimer -->
            <p class="hero-template__disclaimer">
                <?php echo esc_html($disclaimer); ?>
            </p>

            <!-- Statistics -->
            <?php if (!empty($stats)): ?>
                <div class="hero-template__stats">
                    <?php foreach ($stats as $stat): ?>
                        <div class="hero-template__stat">
                            <div class="hero-template__stat-value"><?php echo esc_html($stat['value'] ?? ''); ?></div>
                            <div class="hero-template__stat-label"><?php echo esc_html($stat['label'] ?? ''); ?></div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Right Section - Picks & Stats -->
        <div class="hero-template__right">
            <!-- Main Picks Card -->
            <div class="hero-template__picks-card">
                <div class="hero-template__picks-header">
                    <h3 class="hero-template__picks-title"><?php echo esc_html($picks_title); ?></h3>
                    <?php if ($live_indicator): ?>
                        <div class="hero-template__live-indicator">
                            <span class="hero-template__live-dot"></span>
                            LIVE
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Picks List -->
                <?php if (!empty($picks)): ?>
                    <div class="hero-template__picks-list">
                        <?php foreach ($picks as $index => $pick): ?>
                            <div class="hero-template__pick <?php echo $index > 0 ? 'hero-template__pick--border' : ''; ?>">
                                <div class="hero-template__pick-info">
                                    <div class="hero-template__pick-teams"><?php echo esc_html($pick['teams'] ?? ''); ?></div>
                                    <div class="hero-template__pick-meta">
                                        <?php echo esc_html($pick['league'] ?? ''); ?> • <?php echo esc_html($pick['time'] ?? ''); ?>
                                    </div>
                                </div>
                                <div class="hero-template__pick-selection">
                                    <div class="hero-template__pick-value"><?php echo esc_html($pick['pick'] ?? ''); ?></div>
                                    <div class="hero-template__pick-confidence"><?php echo esc_html($pick['confidence'] ?? ''); ?> Confidence</div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <!-- View All Button -->
                <button class="hero-template__view-all">
                    <?php echo esc_html($view_all_text); ?>
                </button>
            </div>

            <!-- Bottom Stats Cards -->
            <div class="hero-template__bottom-stats">
                <!-- ROI Card -->
                <div class="hero-template__stat-card">
                    <div class="hero-template__stat-card-header">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-trending-up h-4 w-4 text-accent"><polyline points="22 7 13.5 15.5 8.5 10.5 2 17"></polyline><polyline points="16 7 22 7 22 13"></polyline></svg>
                        <div class="hero-template__stat-card-label">ROI</div>
                    </div>
                    <div class="hero-template__stat-card-content">
                        <div class="hero-template__stat-card-value"><?php echo esc_html($roi_value); ?></div>
                        <div class="hero-template__stat-card-period"><?php echo esc_html($roi_period); ?></div>
                    </div>
                </div>

                <!-- Streak Card -->
                <div class="hero-template__stat-card">
                    <div class="hero-template__stat-card-header">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-target h-4 w-4 text-accent"><circle cx="12" cy="12" r="10"></circle><circle cx="12" cy="12" r="6"></circle><circle cx="12" cy="12" r="2"></circle></svg>
                        <div class="hero-template__stat-card-label">Streak</div>
                    </div>
                    <div class="hero-template__stat-card-content">
                        <div class="hero-template__stat-card-value"><?php echo esc_html($streak_value); ?></div>
                        <div class="hero-template__stat-card-period"><?php echo esc_html($streak_period); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
