<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$title = $fields['title'] ?? 'Join 10,000+ sports fans — free in 30 seconds.';
$subtitle = $fields['subtitle'] ?? 'No credit card required. Your data stays safe with us.';
$button_text = $fields['button_text'] ?? 'Create My Free Account →';

// Social buttons
$show_google = $fields['show_google'] ?? true;
$show_apple = $fields['show_apple'] ?? true;
$google_text = $fields['google_text'] ?? 'Continue with Google';
$apple_text = $fields['apple_text'] ?? 'Continue with Apple';

// Terms link
$terms_link = $fields['terms_link'] ?? null;
$terms_url = $terms_link['url'] ?? '#';
$terms_title = $terms_link['title'] ?? 'Terms & Privacy';
$terms_target = $terms_link['target'] ?? '_blank';

// Form fields
$show_password_toggle = $fields['show_password_toggle'] ?? true;
$email_placeholder = $fields['email_placeholder'] ?? 'Enter your email';
$password_placeholder = $fields['password_placeholder'] ?? 'Create a password';
$email_hint = $fields['email_hint'] ?? 'We\'ll never spam you';
$show_captcha = $fields['show_captcha'] ?? true;

// Get settings from options
$form_action = get_option('smarter_blocks_user_signup_form_action', '');
$form_method = get_option('smarter_blocks_user_signup_form_method', 'post');
$redirect_url = get_option('smarter_blocks_user_signup_redirect_url', '');
$success_message = get_option('smarter_blocks_user_signup_success_message', 'Registration successful! Welcome aboard!');
$error_message = get_option('smarter_blocks_user_signup_error_message', 'Registration failed. Please try again.');
$google_client_id = get_option('smarter_blocks_user_signup_google_client_id', '');
$apple_client_id = get_option('smarter_blocks_user_signup_apple_client_id', '');
$google_analytics_id = get_option('smarter_blocks_user_signup_google_analytics_id', '');

// reCAPTCHA settings
$recaptcha_enabled = get_option('smarter_blocks_recaptcha_enabled', 0);
$recaptcha_site_key = get_option('smarter_blocks_recaptcha_site_key', '');

// Custom Google Analytics Events
$custom_ga_events = get_option('smarter_blocks_custom_ga_events', []);
?>
<div class="wp-block-user-signup">
    <div class="signup-container">
        <h2 class="signup-title"><?php echo esc_html($title); ?></h2>
        <p class="signup-subtitle"><?php echo esc_html($subtitle); ?></p>

        <!-- Social Login Buttons -->
        <?php if ($show_google || $show_apple): ?>
        <div class="social-login">
            <?php if ($show_google): ?>
            <button type="button" class="social-btn google-btn" 
                    <?php if ($google_client_id): ?>
                    data-google-client-id="<?php echo esc_attr($google_client_id); ?>"
                    <?php endif; ?>>
                <svg class="google-icon" width="20" height="20" viewBox="0 0 24 24">
                    <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                    <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                    <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                    <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                </svg>
                <?php echo esc_html($google_text); ?>
            </button>
            <?php endif; ?>
            
            <?php if ($show_apple): ?>
            <button type="button" class="social-btn apple-btn"
                    <?php if ($apple_client_id): ?>
                    data-apple-client-id="<?php echo esc_attr($apple_client_id); ?>"
                    <?php endif; ?>>
                <svg class="apple-icon" width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M18.71 19.5c-.83 1.24-1.71 2.45-3.05 2.47-1.34.03-1.77-.79-3.29-.79-1.53 0-2 .77-3.27.82-1.31.05-2.3-1.32-3.14-2.53C4.25 17 2.94 12.45 4.7 9.39c.87-1.52 2.43-2.48 4.12-2.51 1.28-.02 2.5.87 3.29.87.78 0 2.26-1.07 3.81-.91.65.03 2.47.26 3.64 1.98-.09.06-2.17 1.28-2.15 3.81.03 3.02 2.65 4.03 2.68 4.04-.03.07-.42 1.44-1.38 2.83M13 3.5c.73-.83 1.94-1.46 2.94-1.5.13 1.17-.34 2.35-1.04 3.19-.69.85-1.83 1.51-2.95 1.42-.15-1.15.41-2.35 1.05-3.11z"/>
                </svg>
                <?php echo esc_html($apple_text); ?>
            </button>
            <?php endif; ?>
        </div>

        <div class="divider">
            <span class="divider-text">or</span>
        </div>
        <?php endif; ?>

        <form class="signup-form" method="<?php echo esc_attr($form_method); ?>" action="<?php echo esc_attr($form_action ?: '#'); ?>">
            <div class="input-group">
                <input type="email" name="email" class="form-input" placeholder="<?php echo esc_attr($email_placeholder); ?>" required>
                <small class="input-hint"><?php echo esc_html($email_hint); ?></small>
            </div>

            <div class="input-group">
                <div class="password-field">
                    <input type="password" name="password" class="form-input" placeholder="<?php echo esc_attr($password_placeholder); ?>" required>
                    <?php if ($show_password_toggle): ?>
                    <button type="button" class="toggle-password">
                    <svg class="eye-icon" width="20" height="20" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><path d="M320 144C254.8 144 201.2 173.6 160.1 211.7C121.6 247.5 95 290 81.4 320C95 350 121.6 392.5 160.1 428.3C201.2 466.4 254.8 496 320 496C385.2 496 438.8 466.4 479.9 428.3C518.4 392.5 545 350 558.6 320C545 290 518.4 247.5 479.9 211.7C438.8 173.6 385.2 144 320 144zM127.4 176.6C174.5 132.8 239.2 96 320 96C400.8 96 465.5 132.8 512.6 176.6C559.4 220.1 590.7 272 605.6 307.7C608.9 315.6 608.9 324.4 605.6 332.3C590.7 368 559.4 420 512.6 463.4C465.5 507.1 400.8 544 320 544C239.2 544 174.5 507.2 127.4 463.4C80.6 419.9 49.3 368 34.4 332.3C31.1 324.4 31.1 315.6 34.4 307.7C49.3 272 80.6 220 127.4 176.6zM320 400C364.2 400 400 364.2 400 320C400 290.4 383.9 264.5 360 250.7C358.6 310.4 310.4 358.6 250.7 360C264.5 383.9 290.4 400 320 400zM240.4 311.6C242.9 311.9 245.4 312 248 312C283.3 312 312 283.3 312 248C312 245.4 311.8 242.9 311.6 240.4C274.2 244.3 244.4 274.1 240.5 311.5zM286 196.6C296.8 193.6 308.2 192.1 319.9 192.1C328.7 192.1 337.4 193 345.7 194.7C346 194.8 346.2 194.8 346.5 194.9C404.4 207.1 447.9 258.6 447.9 320.1C447.9 390.8 390.6 448.1 319.9 448.1C258.3 448.1 206.9 404.6 194.7 346.7C192.9 338.1 191.9 329.2 191.9 320.1C191.9 309.1 193.3 298.3 195.9 288.1C196.1 287.4 196.2 286.8 196.4 286.2C208.3 242.8 242.5 208.6 285.9 196.7z"/></svg>
                    </button>
                    <?php endif; ?>
                </div>
            </div>

            <div class="terms-group">
                <label class="terms-label">
                    <input type="checkbox" required>
                    <span>I accept <a href="<?php echo esc_url($terms_url); ?>" target="<?php echo esc_attr($terms_target); ?>" class="terms-link"><?php echo esc_html($terms_title); ?></a></span>
                </label>
            </div>

            <!-- reCAPTCHA v3 (invisible) -->
            <?php if ($show_captcha && $recaptcha_enabled && $recaptcha_site_key): ?>
            <input type="hidden" name="recaptcha_response" id="recaptcha_response" value="">
            <?php endif; ?>

            <!-- Hidden fields for settings -->
            <?php if ($redirect_url): ?>
            <input type="hidden" name="redirect_url" value="<?php echo esc_attr($redirect_url); ?>">
            <?php endif; ?>
            
            
            <button type="submit" class="submit-button">
                <?php echo esc_html($button_text); ?>
            </button>
        </form>

        <div class="signup-footer">
            <div class="footer-item">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock w-4 h-4" aria-hidden="true"><rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg> 
                <span>Secure signup</span>
            </div>
            <div class="footer-item">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-users w-4 h-4" aria-hidden="true"><path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path><path d="M16 3.128a4 4 0 0 1 0 7.744"></path><path d="M22 21v-2a4 4 0 0 0-3-3.87"></path><circle cx="9" cy="7" r="4"></circle></svg> 
                <span>Trusted by 10,000 users</span>
            </div>
        </div>
    </div>
</div>

<?php if ($google_analytics_id): ?>
<!-- Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo esc_attr($google_analytics_id); ?>"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', '<?php echo esc_attr($google_analytics_id); ?>');
</script>
<?php endif; ?>

<?php if ($show_captcha && $recaptcha_enabled && $recaptcha_site_key): ?>
<!-- reCAPTCHA v3 -->
<script src="https://www.google.com/recaptcha/api.js?render=<?php echo esc_attr($recaptcha_site_key); ?>"></script>
<script>
window.recaptchaSiteKey = '<?php echo esc_attr($recaptcha_site_key); ?>';
grecaptcha.ready(function() {
    grecaptcha.execute(window.recaptchaSiteKey, {action: 'signup'}).then(function(token) {
        document.getElementById('recaptcha_response').value = token;
    });
});
</script>
<?php endif; ?>

<!-- AJAX Configuration -->
<script>
window.smarter_blocks_ajax = {
    ajax_url: '<?php echo admin_url('admin-ajax.php'); ?>',
    nonce: '<?php echo wp_create_nonce('smarter_blocks_ajax_nonce'); ?>'
};

// Custom Google Analytics Events Configuration
window.smarter_blocks_custom_ga_events = <?php echo json_encode($custom_ga_events); ?>;
</script>