<?php
/**
 * Betting Results Marquee Block Configuration
 */

function smarter_blocks_betting_results_config() {
    return [
        'name' => 'betting-results',
        'title' => 'Betting Results',
        'description' => 'A scrolling marquee displaying recent betting results with win/lose status and profit amounts.',
        'category' => 'formatting',
        'icon' => 'chart-line',
        'keywords' => ['betting', 'results', 'marquee', 'sports', 'wins', 'losses', 'profit'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'betting_data' => [
                        [
                            'description' => 'Under 6.5 Rangers/Devils',
                            'status' => 'win',
                            'profit' => '+$320'
                        ],
                        [
                            'description' => 'Nuggets ML',
                            'status' => 'lose',
                            'profit' => '-$200'
                        ],
                        [
                            'description' => 'Chiefs -2.5',
                            'status' => 'win',
                            'profit' => '+$150'
                        ],
                        [
                            'description' => 'Lakers 112 - 108 Warriors',
                            'status' => 'win',
                            'profit' => '+$280'
                        ],
                        [
                            'description' => 'Over 218.5 Celtics/Heat',
                            'status' => 'win',
                            'profit' => '+$240'
                        ],
                        [
                            'description' => 'Cowboys -3.5',
                            'status' => 'win',
                            'profit' => '+$180'
                        ]
                    ]
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
