<?php
/**
 * Bookie Promo Block Configuration
 */

function smarter_blocks_bookie_promo_config() {
    return [
        'name' => 'bookie-promo',
        'title' => 'Bookie Promo Card',
        'description' => 'Display a promotional card for a betting/gaming platform with logo, promotional text, rating, and call-to-action buttons.',
        'category' => 'widgets',
        'icon' => 'star-filled',
        'keywords' => ['bookie', 'promo', 'betting', 'gaming', 'card', 'promotion'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'badge_number' => '1',
                    'logo_text' => 'BOOKIE',
                    'logo_suffix' => '.ag',
                    'promo_label' => 'Get up to:',
                    'promo_title' => 'Same Day Payouts',
                    'promo_subtitle' => 'DBL your Bankroll',
                    'promo_offer' => 'Send $500 get $500 FREE',
                    'rating' => '5',
                    'play_now_url' => '#',
                    'read_review_url' => '#',
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}

