<?php
/**
 * Betting Consensus Block Configuration
 */

function smarter_blocks_betting_consensus_config() {
    return [
        'name' => 'betting-consensus',
        'title' => 'Betting Consensus',
        'description' => 'A betting consensus widget showing public betting percentages with progress bars for different bet types.',
        'category' => 'widgets',
        'icon' => 'chart-pie',
        'keywords' => ['consensus', 'betting', 'public', 'money', 'percentages', 'sports'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'game_title' => 'Falcons vs Commanders Betting Consensus',
                    'subtitle' => 'See where the public money is going',
                    'team1_name' => 'Atlanta',
                    'team2_name' => 'Washington',
                    'spread_bets' => [
                        'total_bets' => '12,847',
                        'team1_spread' => '+3',
                        'team1_percentage' => 58,
                        'team2_spread' => '-3',
                        'team2_percentage' => 42,
                    ],
                    'total_bets' => [
                        'total_bets' => '9,234',
                        'over_line' => '48.5',
                        'over_percentage' => 65,
                        'under_percentage' => 35,
                    ],
                    'moneyline_bets' => [
                        'total_bets' => '7,891',
                        'team1_odds' => '+125',
                        'team1_percentage' => 52,
                        'team2_odds' => '-150',
                        'team2_percentage' => 48,
                    ],
                    'button_text' => 'Get Consensus Reports Free',
                    'button_url' => '#',
                    'footer_message' => 'Updated every 15 minutes with live betting data from major sportsbooks'
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
