<?php
/**
 * Live Odds Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_live_odds',
    'title' => 'Live Odds Configuration',
    'fields' => [
        [
            'key' => 'field_game_title',
            'label' => 'Game Title',
            'name' => 'game_title',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Falcons vs Commanders Live Odds',
            'default_value' => 'Falcons vs Commanders Live Odds',
        ],
        [
            'key' => 'field_subtitle',
            'label' => 'Subtitle',
            'name' => 'subtitle',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., Shop around for the best lines and maximize your betting value',
            'default_value' => 'Shop around for the best lines and maximize your betting value',
        ],
        [
            'key' => 'field_team1_name',
            'label' => 'Team 1 Name',
            'name' => 'team1_name',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Atlanta Falcons',
            'default_value' => 'Atlanta Falcons',
        ],
        [
            'key' => 'field_team2_name',
            'label' => 'Team 2 Name',
            'name' => 'team2_name',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Washington Commanders',
            'default_value' => 'Washington Commanders',
        ],
        [
            'key' => 'field_active_tab',
            'label' => 'Default Active Tab',
            'name' => 'active_tab',
            'type' => 'radio',
            'required' => 1,
            'choices' => [
                'spread' => 'Spread',
                'moneyline' => 'Moneyline',
                'total' => 'Total',
            ],
            'default_value' => 'spread',
            'layout' => 'horizontal',
            'return_format' => 'value',
        ],
        [
            'key' => 'field_sportsbooks_repeater',
            'label' => 'Sportsbooks',
            'name' => 'sportsbooks',
            'type' => 'repeater',
            'layout' => 'block',
            'required' => 1,
            'min' => 3,
            'max' => 10,
            'button_label' => 'Add Sportsbook',
            'sub_fields' => [
                [
                    'key' => 'field_sportsbook_name',
                    'label' => 'Sportsbook Name',
                    'name' => 'name',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., DraftKings',
                ],
                [
                    'key' => 'field_spread_odds',
                    'label' => 'Spread Odds',
                    'name' => 'spread_odds',
                    'type' => 'group',
                    'layout' => 'block',
                    'sub_fields' => [
                        [
                            'key' => 'field_spread_team1',
                            'label' => 'Team 1 Spread',
                            'name' => 'team1',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., +3 (-110)',
                        ],
                        [
                            'key' => 'field_spread_team2',
                            'label' => 'Team 2 Spread',
                            'name' => 'team2',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., -3 (-110)',
                        ],
                    ],
                ],
                [
                    'key' => 'field_moneyline_odds',
                    'label' => 'Moneyline Odds',
                    'name' => 'moneyline_odds',
                    'type' => 'group',
                    'layout' => 'block',
                    'sub_fields' => [
                        [
                            'key' => 'field_moneyline_team1',
                            'label' => 'Team 1 Moneyline',
                            'name' => 'team1',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., +140',
                        ],
                        [
                            'key' => 'field_moneyline_team2',
                            'label' => 'Team 2 Moneyline',
                            'name' => 'team2',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., -160',
                        ],
                    ],
                ],
                [
                    'key' => 'field_total_odds',
                    'label' => 'Total Odds',
                    'name' => 'total_odds',
                    'type' => 'group',
                    'layout' => 'block',
                    'sub_fields' => [
                        [
                            'key' => 'field_total_over',
                            'label' => 'Over',
                            'name' => 'over',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., O 45.5 (-110)',
                        ],
                        [
                            'key' => 'field_total_under',
                            'label' => 'Under',
                            'name' => 'under',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., U 45.5 (-110)',
                        ],
                    ],
                ],
            ],
        ],
        [
            'key' => 'field_footer_message',
            'label' => 'Footer Message',
            'name' => 'footer_message',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., We track best sports odds daily - Join free to get alerts when lines move in your favor',
            'default_value' => 'We track best sports odds daily - Join free to get alerts when lines move in your favor',
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/live-odds',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure the live odds comparison table for sports games.',
]);
