/**
 * Live Odds Block JavaScript
 * Handles tab switching functionality only
 */

document.addEventListener('DOMContentLoaded', function() {
    const liveOddsContainers = document.querySelectorAll('.live-odds');
    
    liveOddsContainers.forEach(function(container) {
        const tabButtons = container.querySelectorAll('.live-odds__tab');
        const oddsSpans = container.querySelectorAll('.live-odds__odds[data-tab]');
        
        if (!tabButtons.length || !oddsSpans.length) {
            return;
        }
        
        // Add click event listeners to tab buttons
        tabButtons.forEach(function(button) {
            button.addEventListener('click', function() {
                const targetTab = this.getAttribute('data-tab');
                
                // Update tab button states
                tabButtons.forEach(function(btn) {
                    if (btn.getAttribute('data-tab') === targetTab) {
                        btn.classList.add('live-odds__tab--active');
                    } else {
                        btn.classList.remove('live-odds__tab--active');
                    }
                });
                
                // Update odds visibility
                oddsSpans.forEach(function(span) {
                    const spanTab = span.getAttribute('data-tab');
                    if (spanTab === targetTab) {
                        span.style.display = '';
                    } else {
                        span.style.display = 'none';
                    }
                });
            });
        });
    });
});
