<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$primary_text = $fields['primary_text'] ?? 'Get Free Daily Picks';
$secondary_text = $fields['secondary_text'] ?? '';
$cta_link = $fields['cta_link'] ?? null;
$banner_bg_color = $fields['banner_background_color'] ?? '#22c55e';
$button_bg_color = $fields['button_background_color'] ?? '#fbbf24';
$icon_color = $fields['icon_color'] ?? '#f97316';
$show_close_button = $fields['show_close_button'] ?? true;

// Set CSS custom properties
$css_vars = [
    '--mobile-banner-bg' => $banner_bg_color,
    '--mobile-banner-button-bg' => $button_bg_color,
];

$css_vars_string = '';
foreach ($css_vars as $property => $value) {
    $css_vars_string .= $property . ': ' . esc_attr($value) . '; ';
}
?>

<div class="mobile-newsletter-banner" style="<?php echo $css_vars_string; ?>">
    <div class="mobile-newsletter-banner__container">
        <!-- Icon -->
        <div class="mobile-newsletter-banner__icon">
            <svg width="26" height="18" viewBox="0 0 26 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M24.2104 0H1.79334C0.802916 0 0 0.802916 0 1.79334V16.1402C0 17.1307 0.802916 17.9336 1.79334 17.9336H24.2104C25.2008 17.9336 26.0037 17.1307 26.0037 16.1402V1.79334C26.0037 0.802916 25.2008 0 24.2104 0Z" fill="#FFC36E"/>
                <path d="M25.9229 1.28891C25.8341 0.987374 25.6743 0.717484 25.4542 0.504883L15.7592 9.19688L15.5021 8.9664H10.5014L10.2443 9.19688L0.549294 0.504883C0.329176 0.717484 0.169345 0.987424 0.0805664 1.28891L9.57264 9.79908L0.822282 17.6441C1.10248 17.8254 1.43469 17.9332 1.79321 17.9332H24.2102C24.5688 17.9332 24.901 17.8254 25.1811 17.6442L16.4308 9.79903L25.9229 1.28891Z" fill="#FFB464"/>
                <path d="M24.2103 0H19.2787H6.725H1.79323C1.30932 0 0.871925 0.193758 0.549316 0.505295L11.1813 10.0374C12.2172 10.9662 13.7861 10.9662 14.8221 10.0374L25.4541 0.505295C25.1315 0.193758 24.6942 0 24.2103 0Z" fill="#FFD782"/>
            </svg>
        </div>

        <!-- Text Content -->
        <div class="mobile-newsletter-banner__content">
            <div class="mobile-newsletter-banner__primary-text">
                <?php echo esc_html($primary_text); ?>
            </div>
            <?php if (!empty($secondary_text)): ?>
                <div class="mobile-newsletter-banner__secondary-text">
                    <?php echo esc_html($secondary_text); ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- CTA Button -->
        <?php if ($cta_link && !empty($cta_link['url'])): ?>
            <a href="<?php echo esc_url($cta_link['url']); ?>" 
               target="<?php echo esc_attr($cta_link['target'] ?? '_self'); ?>"
               class="mobile-newsletter-banner__button">
                <?php echo esc_html($cta_link['title'] ?? 'Sign Up'); ?>
            </a>
        <?php endif; ?>

        <!-- Close Button -->
        <?php if ($show_close_button): ?>
            <button type="button" class="mobile-newsletter-banner__close" aria-label="Close banner">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="18" y1="6" x2="6" y2="18"></line>
                    <line x1="6" y1="6" x2="18" y2="18"></line>
                </svg>
            </button>
        <?php endif; ?>
    </div>
</div>

