<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$card_background = $fields['card_background'] ?? '#ffffff';
$team1 = $fields['team1'] ?? [];
$team2 = $fields['team2'] ?? [];
$betting_odds = $fields['betting_odds'] ?? [];

// Set CSS custom properties
$css_vars = [
    '--sports-matchup-card-bg' => $card_background,
    '--team1-color' => $team1['color'] ?? '#E50000',
    '--team2-color' => $team2['color'] ?? '#A07828',
];
$css_vars_string = '';
foreach ($css_vars as $property => $value) {
    $css_vars_string .= $property . ': ' . esc_attr($value) . '; ';
}
?>

<div class="sports-matchup" style="<?php echo $css_vars_string; ?>">
    <div class="sports-matchup__card">
        <!-- Team 1 Section (Left) -->
        <div class="sports-matchup__team sports-matchup__team--left">
            <div class="sports-matchup__team-icon sports-matchup__team-icon--team1">
                <?php echo esc_html($team1['abbreviation'] ?? ''); ?>
            </div>
            <div class="sports-matchup__team-info">
                <div class="sports-matchup__team-name">
                    <?php echo esc_html($team1['team1_name'] ?? 'Team 1 Name'); ?>
                </div>
                <div class="sports-matchup__team-record">
                    <?php echo esc_html($team1['record'] ?? ''); ?>
                </div>
            </div>
        </div>

        <!-- Center Section (VS and Odds) -->
        <div class="sports-matchup__center">
            <div class="sports-matchup__game-status-desktop"><?php echo esc_html($betting_odds['game_status'] ?? ''); ?></div> 
            <div class="sports-matchup__vs">VS</div>
            <div class="sports-matchup__odds-desktop">
                <div class="sports-matchup__odds-box">
                    <span class="sports-matchup__odds-label">Spread: </span>
                    <span class="sports-matchup__odds-value"><?php echo esc_html($betting_odds['spread'] ?? ''); ?></span>
                </div>
                <div class="sports-matchup__odds-box">
                    <span class="sports-matchup__odds-label">O/U: </span>
                    <span class="sports-matchup__odds-value"><?php echo esc_html($betting_odds['over_under'] ?? ''); ?></span>
                </div>
                <div class="sports-matchup__odds-box">
                    <span class="sports-matchup__odds-label">Moneyline: </span>
                    <span class="sports-matchup__odds-value"><?php echo esc_html($betting_odds['moneyline'] ?? ''); ?></span>
                </div>
            </div>
        </div>

        <!-- Team 2 Section (Right) -->
        <div class="sports-matchup__team sports-matchup__team--right">
            <div class="sports-matchup__team-icon sports-matchup__team-icon--team2">
                <?php echo esc_html($team2['abbreviation'] ?? ''); ?>
            </div>
            <div class="sports-matchup__team-info">
                <div class="sports-matchup__team-name">
                    <?php echo esc_html($team2['team2_name'] ?? 'Team 2 Name'); ?>
                </div>
                <div class="sports-matchup__team-record">
                    <?php echo esc_html($team2['record'] ?? ''); ?>
                </div>
            </div>
        </div>
        <div class="sports-matchup__odds-mobile">
            <div class="sports-matchup__game-status-mobile"><?php echo esc_html($betting_odds['game_status'] ?? ''); ?></div> 
                <div class="sports-matchup__odds-box">
                    <span class="sports-matchup__odds-label">Spread: </span>
                    <span class="sports-matchup__odds-value"><?php echo esc_html($betting_odds['spread'] ?? ''); ?></span>
                </div>
                <div class="sports-matchup__odds-box">
                    <span class="sports-matchup__odds-label">O/U: </span>
                    <span class="sports-matchup__odds-value"><?php echo esc_html($betting_odds['over_under'] ?? ''); ?></span>
                </div>
                <div class="sports-matchup__odds-box">
                    <span class="sports-matchup__odds-label">Moneyline: </span>
                    <span class="sports-matchup__odds-value"><?php echo esc_html($betting_odds['moneyline'] ?? ''); ?></span>
                </div>
        </div>
    </div>
</div>
