<?php
/**
 * Pricing Cards Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_pricing_cards',
    'title' => 'Pricing Cards',
    'fields' => [
        [
            'key' => 'field_pricing_cards_repeater',
            'label' => 'Pricing Cards',
            'name' => 'pricing_cards',
            'type' => 'repeater',
            'layout' => 'row',
            'required' => 1,
            'min' => 1,
            'max' => 3,
            'button_label' => 'Add Pricing Card',
            'sub_fields' => [
                [
                    'key' => 'field_most_popular',
                    'label' => 'Most Popular',
                    'name' => 'most_popular',
                    'type' => 'true_false',
                    'required' => 0,
                    'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => 'Yes',
                    'ui_off_text' => 'No',
                ],
                [
                    'key' => 'field_card_title',
                    'label' => 'Title',
                    'name' => 'title',
                    'type' => 'text',
                    'required' => 1,
                    'default_value' => 'Plan Name',
                    'placeholder' => 'Enter plan title',
                ],
                [
                    'key' => 'field_card_price',
                    'label' => 'Price',
                    'name' => 'price',
                    'type' => 'number',
                    'required' => 1,
                    'default_value' => 0,
                    'min' => 0,
                    'step' => 0.01,
                    'placeholder' => '0.00',
                ],
                [
                    'key' => 'field_card_price_period',
                    'label' => 'Price Period',
                    'name' => 'price_period',
                    'type' => 'text',
                    'required' => 0,
                    'default_value' => '/month',
                    'placeholder' => '/month, /year, /forever, etc.',
                ],
                [
                    'key' => 'field_card_description',
                    'label' => 'Description',
                    'name' => 'description',
                    'type' => 'text',
                    'required' => 0,
                    'placeholder' => 'Enter plan description',
                ],
                [
                    'key' => 'field_card_list',
                    'label' => 'Features List',
                    'name' => 'list',
                    'type' => 'repeater',
                    'layout' => 'table',
                    'required' => 0,
                    'min' => 0,
                    'button_label' => 'Add Feature',
                    'sub_fields' => [
                        [
                            'key' => 'field_list_option',
                            'label' => 'Feature',
                            'name' => 'list_option',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'Enter feature description',
                        ],
                    ],
                ],
                [
                    'key' => 'field_card_cta',
                    'label' => 'Call to Action',
                    'name' => 'cta',
                    'type' => 'link',
                    'required' => 1,
                    'return_format' => 'array',
                ],
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/pricing-cards',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure up to 3 pricing cards with features and CTAs.',
]);
