<?php
/**
 * Pricing Cards Block Configuration
 */

function smarter_blocks_pricing_cards_config() {
    return [
        'name' => 'pricing-cards',
        'title' => 'Pricing Cards',
        'description' => 'A pricing cards section with up to 3 cards, featuring most popular badge, pricing, features list, and CTA.',
        'category' => 'formatting',
        'icon' => 'money-alt',
        'keywords' => ['pricing', 'cards', 'plans', 'subscription', 'pricing-table'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'pricing_cards' => [
                        [
                            'most_popular' => false,
                            'title' => 'Free',
                            'price' => 0,
                            'description' => 'Get started with daily picks',
                            'list' => [
                                ['list_option' => '1 free pick daily'],
                                ['list_option' => 'Basic analysis'],
                                ['list_option' => 'Email delivery'],
                                ['list_option' => 'Community access']
                            ],
                            'cta' => [
                                'title' => 'Get Free Pick',
                                'url' => '#',
                                'target' => '_self'
                            ]
                        ],
                        [
                            'most_popular' => true,
                            'title' => 'Starter',
                            'price' => 25,
                            'description' => 'Perfect for casual bettors',
                            'list' => [
                                ['list_option' => 'All free features'],
                                ['list_option' => '5 premium picks daily'],
                                ['list_option' => 'Advanced analytics'],
                                ['list_option' => 'SMS notifications'],
                                ['list_option' => 'Handicapper insights'],
                                ['list_option' => 'Betting calculator']
                            ],
                            'cta' => [
                                'title' => 'Start 7-Day Trial',
                                'url' => '#',
                                'target' => '_self'
                            ]
                        ],
                        [
                            'most_popular' => false,
                            'title' => 'Premium',
                            'price' => 85,
                            'description' => 'For serious bettors',
                            'list' => [
                                ['list_option' => 'All starter features'],
                                ['list_option' => 'Unlimited picks'],
                                ['list_option' => 'Real-time alerts'],
                                ['list_option' => 'VIP Discord access'],
                                ['list_option' => 'Personal handicapper'],
                                ['list_option' => 'Advanced tools'],
                                ['list_option' => 'Priority support'],
                                ['list_option' => 'Exclusive content']
                            ],
                            'cta' => [
                                'title' => 'Go Premium',
                                'url' => '#',
                                'target' => '_self'
                            ]
                        ]
                    ]
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
