<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$pricing_cards = $fields['pricing_cards'] ?? [];
?>

<div class="pricing-cards-container">
    <div class="pricing-cards-grid">
        <?php if (have_rows('pricing_cards')): ?>
            <?php while (have_rows('pricing_cards')): the_row(); 
                $most_popular = get_sub_field('most_popular');
                $title = get_sub_field('title');
                $price = get_sub_field('price');
                $price_period = get_sub_field('price_period') ?? '/month';
                $description = get_sub_field('description');
                $cta = get_sub_field('cta');
                
                $cta_title = $cta['title'] ?? 'Get Started';
                $cta_url = $cta['url'] ?? '#';
                $cta_target = $cta['target'] ?? '_self';
            ?>
                <div class="pricing-card <?php echo $most_popular ? 'most-popular' : ''; ?>">
                    <?php if ($most_popular): ?>
                        <div class="popular-badge">
                            <span class="star-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star h-3 w-3">
                                    <path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path>
                                </svg>
                            </span>
                            <span class="badge-text">Most Popular</span>
                        </div>
                    <?php endif; ?>
                    
                    <div class="card-content">
                        <p class="card-title"><?php echo esc_html($title); ?></p>
                        
                        <div class="price-section">
                            <span class="price">$<?php echo esc_html(number_format($price, 0)); ?></span>
                            <span class="price-period">
                                <?php echo esc_html($price_period); ?>
                            </span>
                        </div>
                        
                        <?php if ($description): ?>
                            <p class="card-description"><?php echo esc_html($description); ?></p>
                        <?php endif; ?>
                        
                        <ul class="features-list">
                            <?php if (have_rows('list')): ?>
                                <?php while (have_rows('list')): the_row(); 
                                    $list_option = get_sub_field('list_option');
                                ?>
                                    <li class="feature-item">
                                        <span class="check-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check h-4 w-4 text-accent shrink-0">
                                                <path d="M20 6 9 17l-5-5"></path>
                                            </svg>
                                        </span>
                                        <span class="feature-text"><?php echo esc_html($list_option); ?></span>
                                    </li>
                                <?php endwhile; ?>
                            <?php endif; ?>
                        </ul>
                        
                        <a href="<?php echo esc_url($cta_url); ?>" 
                           target="<?php echo esc_attr($cta_target); ?>" 
                           class="cta-button <?php echo $most_popular ? 'primary' : 'secondary'; ?>">
                            <?php echo esc_html($cta_title); ?>
                        </a>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php endif; ?>
    </div>
</div>
