<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$betting_data = $fields['betting_data'] ?? [];
?>

<div class="betting-results-container">
    <div class="betting-marquee">
        <div class="marquee-content">
            <?php if (have_rows('betting_data')): ?>
                <?php 
                // First pass - collect all items
                $all_items = [];
                while (have_rows('betting_data')): the_row(); 
                    $description = get_sub_field('description');
                    $status = get_sub_field('status');
                    $profit = get_sub_field('profit');
                    
                    // Determine status class and display
                    $status_class = '';
                    $status_text = '';
                    switch ($status) {
                        case 'win':
                            $status_class = 'win';
                            $status_text = 'W';
                            break;
                        case 'lose':
                            $status_class = 'lose';
                            $status_text = 'L';
                            break;
                        case 'push':
                            $status_class = 'push';
                            $status_text = 'P';
                            break;
                    }
                    
                    $all_items[] = [
                        'status_class' => $status_class,
                        'status_text' => $status_text,
                        'description' => $description,
                        'profit' => $profit
                    ];
                endwhile;
                
                // Render items twice for seamless loop
                for ($i = 0; $i < 2; $i++):
                    foreach ($all_items as $index => $item):
                ?>
                    <div class="betting-item">
                        <span class="bet-description"><?php echo esc_html($item['description']); ?></span>
                        <div class="status-indicator <?php echo esc_attr($item['status_class']); ?>">
                            <?php echo esc_html($item['status_text']); ?>
                        </div>
                        <span class="profit-amount"><?php echo esc_html($item['profit']); ?></span>
                    </div>
                    <div class="separator-dot"></div>
                <?php 
                    endforeach;
                endfor;
                ?>
            <?php endif; ?>
        </div>
    </div>
</div>
