<?php
/**
 * User Signup Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_user_signup',
    'title' => 'User Signup',
    'fields' => [
        [
            'key' => 'field_user_signup_title',
            'label' => 'Main Title',
            'name' => 'title',
            'type' => 'text',
            'required' => 0,
            'default_value' => 'Join 10,000+ sports fans — free in 30 seconds.',
        ],
        [
            'key' => 'field_user_signup_subtitle',
            'label' => 'Subtitle',
            'name' => 'subtitle',
            'type' => 'text',
            'required' => 0,
            'default_value' => 'No credit card required. Your data stays safe with us.',
        ],
        [
            'key' => 'field_user_signup_button_text',
            'label' => 'Button Text',
            'name' => 'button_text',
            'type' => 'text',
            'required' => 0,
            'default_value' => 'Create My Free Account →',
        ],
        [
            'key' => 'field_user_signup_show_google',
            'label' => 'Show Google Button',
            'name' => 'show_google',
            'type' => 'true_false',
            'required' => 0,
            'default_value' => 1,
        ],
        [
            'key' => 'field_user_signup_google_text',
            'label' => 'Google Button Text',
            'name' => 'google_text',
            'type' => 'text',
            'required' => 0,
            'default_value' => 'Continue with Google',
            'conditional_logic' => [
                [
                    [
                        'field' => 'field_user_signup_show_google',
                        'operator' => '==',
                        'value' => '1',
                    ],
                ],
            ],
        ],
        [
            'key' => 'field_user_signup_show_apple',
            'label' => 'Show Apple Button',
            'name' => 'show_apple',
            'type' => 'true_false',
            'required' => 0,
            'default_value' => 1,
        ],
        [
            'key' => 'field_user_signup_apple_text',
            'label' => 'Apple Button Text',
            'name' => 'apple_text',
            'type' => 'text',
            'required' => 0,
            'default_value' => 'Continue with Apple',
            'conditional_logic' => [
                [
                    [
                        'field' => 'field_user_signup_show_apple',
                        'operator' => '==',
                        'value' => '1',
                    ],
                ],
            ],
        ],
        [
            'key' => 'field_user_signup_terms_link',
            'label' => 'Terms & Privacy Link',
            'name' => 'terms_link',
            'type' => 'link',
            'required' => 0,
            'return_format' => 'array',
        ],
        [
            'key' => 'field_user_signup_show_password_toggle',
            'label' => 'Show Password Toggle',
            'name' => 'show_password_toggle',
            'type' => 'true_false',
            'required' => 0,
            'default_value' => 1,
        ],
        [
            'key' => 'field_user_signup_email_placeholder',
            'label' => 'Email Placeholder',
            'name' => 'email_placeholder',
            'type' => 'text',
            'required' => 0,
            'default_value' => 'Enter your email',
        ],
        [
            'key' => 'field_user_signup_password_placeholder',
            'label' => 'Password Placeholder',
            'name' => 'password_placeholder',
            'type' => 'text',
            'required' => 0,
            'default_value' => 'Create a password',
        ],
        [
            'key' => 'field_user_signup_email_hint',
            'label' => 'Email Help Text',
            'name' => 'email_hint',
            'type' => 'text',
            'required' => 0,
            'default_value' => 'We\'ll never spam you',
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/user-signup',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
]);